/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include <ctype.h>
#include <stdlib.h>

#ifndef cstring_h
#define cstring_h 1

class ostream;

class cstring {
protected:
  char* string;
  int len;

public:
  cstring(const char* s) {
    len = strlen(s) + 1;
    string = new char[len];
    strcpy(string, s);
  }
#if __GNUG__ == 2
  ~cstring() { delete[] string; }
#else
  ~cstring() { delete[len] string; }
#endif
  cstring(cstring& s) : len(s.len) {
    string = new char[len];
    strcpy(string, s.string);
  }
  cstring& operator=(const cstring&);
  operator const char*() { return string; }
  int length() { return len; }

  friend ostream& operator<<(ostream&, cstring&);
};

#endif cstring_h

