/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include <stream.h>
#include <ctype.h>
#include "cstring.h"

ostream& operator<<(ostream& ost, cstring& s)
{
  ost << "\"";
  char* p = s;
  while (*p) {
    if ((*p & 0x7f) == *p) {
      if (isprint(*p) && *p != '\"' && *p != '\\') {
	ost << *p++; continue;
      }
    }
    switch (*p) {
    case '\n':
      ost << "\\n"; break;
    case '\t':
      ost << "\\t"; break;
    case '\\':
      ost << "\\\\"; break;
    case '\"':
      ost << "\\\""; break;
    default:
      ost << form("\\x%02x", *p & 0xff);
      break;
    }
    p++;
  }
  ost << "\"";
  return ost;
}

