/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef Name_h
#define Name_h 1

#include <assert.h>
#include <stream.h>
#include <string.h>
#include "gList.h"

class Name {
protected:
  char* string;
  int len;

  Name(char* s, int l) : string(s), len(l) { assert(strlen(s) == l); }

public:
  Name(const char* s) {
    len = strlen(s) + 1;
    string = new char[len];
    strcpy(string, s);
  }
#if __GNUG__ == 2
  ~Name() { delete[] string; }
#else
  ~Name() { delete[len] string; }
#endif
  Name(const Name& n) : len(n.len) {
    string = new char[len];
    strcpy(string, n.string);
  }
  Name& operator=(const Name&);
  operator char*() { return string; }
  int length() const { return len; }
  Name escape(char, char) const;
  friend Name escaped(Name& n, char t, char e) {
    return n.escape(t, e);
  }
  Name enclose(char) const;
};

inline ostream& operator<<(ostream& ost, Name* np)
{
  ost << (char*)*np;
  return ost;
}

declare(gList,Name);

struct NameList : gList(Name) {
};

struct NameListItr : gList_iterator(Name) {
};

#endif Name_h
