/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include "Name.h"

Name& Name::operator=(const Name& from)
{
  if (this != &from) {
#if __GNUG__ == 2
    delete[] string;
#else
    delete[len] string;
#endif
    len = from.len;
    string = new char[len];
    strcpy(string, from.string);
  }
  return *this;
}

Name Name::escape(char target, char escapechar) const
{
  int n = 0;
  for (char* s = string ; *s ; s++) { if (*s == target) n++; }
  char* newbuf = new char[len + n];
  char* p = newbuf;
  for (s = string ; *s ; s++) {
    if (*s == target) { *p++ = escapechar; }
    *p++ = *s;
  }
  *p = '\0';
  Name newname(newbuf);
#if __GNUG__ == 2
  delete[] newbuf;
#else
  delete[len + n] newbuf;
#endif
  return newname;
}

Name Name::enclose(char echar) const
{
  char* newbuf = new char[len + 2];
  char* p = newbuf;
  *p++ = echar;
  char* s = string;
  while (*s) { *p++ = *s++; }
  *p++ = echar;
  *p = '\0';
  Name newname(newbuf);
#if __GNUG__ == 2
  delete[] newbuf;
#else
  delete[len + 2] newbuf;
#endif
  return newname;
}
