/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef MHList_h
#define MHList_h 1

typedef void* ptr;

class MHNode {
friend class MHList;
friend class MHList_iterator;
  MHNode* next;
  ptr value;
  int rc;
public:
  MHNode(ptr v, MHNode* n) : next(n), value(v), rc(1) {}
};

class MHList {
friend class MHList_iterator;
  MHNode* top;
public:
  MHList() : top(0) {}
  MHList(const MHList& l) : top(l.top) { if (top) top->rc++; }
  ~MHList();
  void push(ptr u) { top = new MHNode(u, top); }
  ptr pop();
  void insert(MHNode* i, ptr u) { i->next = new MHNode(u, i->next); }
  int length();
};

class MHList_iterator {
  MHList* list;
  MHNode* node;
public:
  MHList_iterator(MHList* l) { list = l; node = l->top; }
  ptr operator()();
  void step();
  ptr next() { step(); return (*this)(); }
};

inline void MHList_iterator::step()
{
  if (node) node = node->next;
}

inline ptr MHList_iterator::operator()()
{
  return (node ? node->value : 0);
}

#endif MHList_h
