/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include "MHList.h"

MHList::~MHList()
{
  if (top == 0) return;
  MHNode* a = top;
  a->rc--;
  if (a->rc > 0) return;
  MHNode* b = a->next;
  delete a;
  a = b;
  while (a != 0) {
    a->rc--;
    if (a->rc > 0) break;
    b = a->next;
    delete a;
    a = b;
  }
}

ptr MHList::pop()
{
  if (top) {
    MHNode* n = top;
    top = top->next;
    ptr p = n->value;
    if (--(n->rc) == 0) delete n;
    return p;
  }
  else return 0;
}

int MHList::length()
{
  MHNode* np = top;
  int i = 0;
  while (np) {
    i++;
    np = np->next;
  }
  return i;
}
