/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef List_h
#define List_h 1

typedef void* pix;
typedef void* ptr;

class Node {
friend class List;
friend class List_iterator;
  Node* next;
  ptr value;
public:
  Node(ptr v, Node* n) { next = n; value = ptr(v); }
};

class List {
friend class List_iterator;
  Node* lastNode;
public:
  List() { lastNode = 0; }
  List(List& l) : lastNode(l.lastNode) {}
  ~List();
  void add(ptr);
  void push(ptr);
  ptr pop();
  void insert(pix, ptr);
  int length();
  ptr last() { return (lastNode ? lastNode->value : 0); }
};

class List_iterator {
  List* list;
  Node* node;
public:
  List_iterator(List* l) { list = l; node = (list ? l->lastNode : 0); }
  ptr operator()();
  void step();
  ptr next();
  pix index() { return pix(node); }
  void reset() { node = list->lastNode; }
  ptr find(ptr);
  ptr remove();
};

inline void List_iterator::step()
{
  if (node) node = node->next;
  if (node == list->lastNode) node = 0;
}

inline ptr List_iterator::operator()()
{
  return (node && node->next ? node->next->value : 0);
}

#endif List_h
