/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include "List.h"

List::~List() {
  if (lastNode != 0) {
    Node* a = lastNode;
    Node* b = a->next;
    delete a;
    a = b;
    while (a != lastNode) {
      b = a->next;
      delete a;
      a = b;
    }
  }
}

void List::add(ptr u)
{
  if (lastNode) lastNode = lastNode->next = new Node(u, lastNode->next);
  else {
    lastNode = new Node(u, 0);
    lastNode->next = lastNode;
  }
}

void List::push(ptr u)
{
  if (lastNode) lastNode->next = new Node(u, lastNode->next);
  else {
    lastNode = new Node(u, 0);
    lastNode->next = lastNode;
  }
}

ptr List::pop()
{
  if (lastNode) {
    Node* n = lastNode->next;
    if (n == lastNode) lastNode = 0;
    else lastNode->next = n->next;
    ptr p = n->value;
    delete n;
    return p;
  }
  else return 0;
}

ptr List_iterator::next()
{
  step();
  if (node == list->lastNode) node = 0;
  return (*this)();
}

void List::insert(pix i, ptr u)
{
  if (i) {
    Node* a = (Node*)i;
    a->next = new Node(u, a->next);
  }
  else if (lastNode) {
    lastNode = lastNode->next = new Node(u, lastNode->next);
  }
  else {
    lastNode = new Node(u, 0);
    lastNode->next = lastNode;
  }
}

int List::length()
{
  Node* np = lastNode;
  if (np == 0) return 0;
  int i = 1;
  for (np = np->next ; np != lastNode ; np = np->next) {
    i++;
  }
  return i;
}

ptr List_iterator::find(ptr p)
{
  for (ptr p2 = operator () () ; p2 ; p2 = next()) {
    if (p2 == p) return p2;
  }
  return 0;
}

ptr List_iterator::remove()
{
  if (node == 0) return 0;
  Node* n2 = node->next;
  if (n2 == node) {		// # of node == 1
    list->lastNode = 0;
    Node* r = node;
    node = 0;
    return r;
  }
  else {			// # of nodes > 1
    if (list->lastNode == n2) {
      list->lastNode = node;
    }
    node->next = n2->next;
    return n2;
  }
}
