/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef Array_h
#define Array_h 1

typedef void* voidp;

class Array {

  friend class ArrayItr;	// iterator class
  friend class ArrayIt;		// another iterator class;

  int size;
  void** elements;

public:
  Array(int n) : size(n) { elements = new voidp[n]; }
  void*& operator[](int i) { return elements[i]; }
  int length() const { return size; }
};

class ArrayItr {

  int i;
  Array& array;

public:
  ArrayItr(Array& a) : i(0), array(a) {}
  void* operator()() { return (i < array.length() ? array[i] : 0); }
  void* next() { return (++i < array.length() ? array[i] : 0); }
  void reset() { i = 0; }
};

#endif Array_h
