/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

// SCvar --- SCope tree node constituent for variables

#ifndef SCvar_h
#define SCvar_h 1

#include <string.h>
#include <stream.h>
#include "gMHList.h"
#include "SNstream.h"
#include "OnOff.h"

class SCvar {
friend class SCvarList;

  SNstream* snsrmp;	   // Corresponding node in the syntax tree
  char* nameString;	       // Name of this var
  char RootFlag;	 // Whether this var is the root of SCope tree
  char LeafFlag;	 // Whether this var is a leaf of SCope tree
  char InletOffspringFlag; // Whether inlet is in its offsprings
  char InletFlag;	   // Whether this var is inlet

public:
  SCvar(SNstream*);
  SCvar(SCvar& v)
    : snsrmp(v.snsrmp), nameString(v.nameString),
      RootFlag(v.RootFlag), LeafFlag(v.LeafFlag),
      InletOffspringFlag(v.InletOffspringFlag), InletFlag(v.InletFlag) {}
  char* name() { return nameString; }
  int isRoot() { return RootFlag; }
  void setRoot(OnOff b) { RootFlag = b; }
  int isLeaf() { return LeafFlag; }
  void setLeaf(OnOff b) { LeafFlag = b; }
  int hasInletOffspring() { return InletOffspringFlag; }
  void setInletOffspring(OnOff b) { InletOffspringFlag = b; }
  int isInlet() { return InletFlag; }
  void setInlet(OnOff b) { InletFlag = b; }
  friend int operator==(SCvar a, SCvar b)
    { return strcmp(a.nameString, b.nameString) == 0; }
  void print(int);
  void split();
  SNstream* snstream() { return snsrmp; }
};

declare(gMHList, SCvar);

struct SCvarList : gMHList(SCvar) {
  SCvarList() {}
  SCvarList(const SCvarList& l) : (l) {}
  SCvar* find(SCvar* key) { return find(key->nameString); }
  SCvar* find(char*);
};

#endif SCvar_h
