/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include <string.h>
#include "indent.h"
#include "SCvar.h"

SCvar::SCvar(SNstream* srmp)
{
  nameString = srmp->get_name();
  RootFlag = LeafFlag = InletOffspringFlag = OFF;
  setInlet(OFF);
  snsrmp = srmp;
  gList_iterator(orderCount) orders(&(srmp->get_appearances()));
  for (orderCount* ocp = orders() ; ocp ; ocp = orders.next()) {
    if (ocp->order == ORD_INLET) {
      setInlet(ON);
      break;
    }
  }
}

void SCvar::print(int from)
{
  indent space(from);
  cout << space << nameString;
  if (isRoot()) cout << " Root";
  if (isLeaf()) cout << " Leaf";
  if (isInlet()) cout << " Inlet";
  if (hasInletOffspring()) cout << " InletOffspring";
  cout << "\n";
}

void SCvar::split()
{
  snsrmp->count(InletOffspringFlag == ON ? ORD_INLET : ORD_OUTLET);
}

SCvar* SCvarList::find(char* key)
{
  gMHList_iterator(SCvar) vars(this);
  for (SCvar* vp = vars() ; vp ; vp = vars.next()) {
    if (strcmp(vp->name(), key) == 0) return vp;
  }
  return 0;
}
