/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include "SCtree.h"
#include "gList.h"
#include "SCclass.h"
#include "SCmethod.h"
#include "SCvar.h"
#include "SCimport.h"
#include "SNerror.h"
#include "errmsg.h"

declare(gList,SCclass);

// void MarkRootandLeaf(SCclass* current)
// {
//   for (current Τ٤ƤΥ᥽å method ˤĤ) {
//     for (method Τ٤Ƥѿ var ˤĤ) {
//	 Ȥꤢ var  Leaf ǤȤƤ
//	 current οƤϤơ
//	 롼Ȥޤǥ饹դˤɤʤ {
//	   if (var ƱѿäƤ륯饹) break;
//	   ɤä饹Ͽ롣
//	 }
//	 if (var Ʊѿäʤ) {
//	    Leaf ǤϤʤ
//	   Ͽ٤ƤΥ饹ˤĤ {
//	     var ͢롣
//	   }
//	 }
//	 else var  Root Ǥ롣
//     }
//     for (method Τ٤ƤΥ饹 class ˤĤ) {
//	 MarkRootandLeaf(class);
//     }
//   }
// }

void markRootandLeaf(SCclass* current)
// Mark the root and leafs of each variable in the SCope tree.
// Also register imported variables in each class.
{
  methodsInSCclass methods(current);
  for (SCmethod* mp = methods() ; mp ; mp = methods.next()) {
    varsInSCmethod vars(mp);
    for (SCvar* vp = vars(); vp ; vp = vars.next()) {
      vp->setLeaf(ON);
      gList(SCclass) ancestors;
      SCclass* classNode = current;
      SCmethod* methodNode = classNode->caller();
      SCvar* varNode;
      while (methodNode) {
	if (classNode->find(vp) != 0) break;
	if ((varNode = methodNode->find(vp)) != 0) {
	  varNode->setLeaf(OFF);
	  classNode->import(vp);
	  break;
	}
	ancestors.push(classNode);
	classNode = methodNode->owner();
	methodNode = classNode->caller();
      }
      if (methodNode) {
	while (classNode != current) {
	  classNode = ancestors.pop();
	  classNode->import(new SCvar(*vp));
	}
      }
      else vp->setRoot(ON);
    }
    classesInSCmethod classes(mp);
    for (SCclass* clp = classes() ; clp ; clp = classes.next()) {
      markRootandLeaf(clp);
    }
  }
}

// void markAncestorofInlet(SCclass* current)
// {
//   for (current Τ٤ƤΥ᥽å method ˤĤ) {
//     for (method Τ٤Ƥѿ var ˤĤ) {
//	 if (var  Inlet ʤ) {
//	   if (var  Root ʤ) continue;
//	   current Ϥơ
//	   롼Ȥޤǥ饹 class 򤿤ɤʤ {
//	     if (Ǥ var  Inlet Ȥ͢Ƥ) break;
//	     ͢ѿɽ var  Inlet ȤƵϿ
//	     class θƤӽФ᥽å caller 
//	     if (Ǥ Inlet Inlet λ¹ var äƤС
//		 error();
//	     else {
//		 for (method Τ٤ƤΥ饹 volatile ˤĤ) {
//		     volatile  class Ʊʤ continue;
//		     if (volatile  var  inlet Ȥ͢Ƥʤ)
//			 error();
//		 }
//		 caller  Inlet λ¹ var 롣
//	     }
//	     if (caller  var  Root äƤbreak;
//	   }
//	 }
//     }
//     for (method Τ٤ƤΥ饹 class ˤĤ) {
//	 markAncestorofInlet(class);
//     }
//   }
// }

void markAncestorofInlet(SCclass* current)
{
  methodsInSCclass methods(current);
  for (SCmethod* mp = methods() ; mp ; mp = methods.next()) {
    varsInSCmethod vars(mp);
    for (SCvar* vp = vars() ; vp ; vp = vars.next()) {
      if (vp->isInlet() && !vp->isRoot()) {
	SCvar* varNode = vp;
	SCclass* classNode = current;
	for (;;) {
	  SCimport* importNode = classNode->find(vp);
	  if (importNode->isInlet()) break;
	  importNode->setInlet(ON);
	  SCmethod* methodNode = classNode->caller();
	  varNode = methodNode->find(vp);
	  if (varNode) {
	    if (varNode->isInlet() || varNode->hasInletOffspring()) {
	      Name mname = methodNode->snmethod()->selector()->string();
	      sprintf(ErrorMessageBuffer,
		      "variable '%s' in method '%s' has two inlets",
		      vp->name(),
		      (char*)mname);
	      SNerror(ErrorMessageBuffer,
			methodNode->snmethod()->LineNumber());
	    }
	    else varNode->setInletOffspring(ON);
	    if (varNode->isRoot()) break;
	  }
	  else {
	    classesInSCmethod classes(methodNode);
	    for (SCclass* clp = classes() ; clp ; clp = classes.next()) {
	      if (clp == classNode) continue;
	      importNode = clp->find(vp);
	      if (importNode && importNode->isInlet()) {
		Name mname = methodNode->snmethod()->selector()->string();
		sprintf(ErrorMessageBuffer,
			"variable '%s' in method '%s' has two inlets",
			vp->name(),
			(char*)mname);
		SNerror(ErrorMessageBuffer,
			  methodNode->snmethod()->LineNumber());
	      }
	    }
	  }
	  classNode = methodNode->owner();
	}
      }
    }
    classesInSCmethod classes(mp);
    for (SCclass* clp = classes() ; clp ; clp = classes.next()) {
      markAncestorofInlet(clp);
    }
  }
}

// void markSinks(SCclass* current, gList(SCvar)& targets)
// {
//   for (current ͢Ƥ뤹٤Ƥѿ import ˤĤ) {
//     if (import  targets ˴ޤޤƤ) {
//	 import  sink Ǥ뤳ȤϿ롣
//     }
//   }
//   for (current Τ٤ƤΥ᥽å method ˤĤ) {
//     for (method Τ٤Ƥѿ var ˤĤ) {
//	 if (var  Inlet ǤϤʤInlet λ¹ʤʤ) {
//	   if (var  Root ʤС {
//	     var  targets ˲ä;
//	   }
//	   else if (var  Inlet Ȥ͢Ƥʤ) {
//	     var  targets äƤʤ targets ˲ä;
//	   }
//	 }
//     }
//     for (method Τ٤ƤΥ饹 class ˤĤ) {
//	 markSinks(class, targets)
//     }
//   }
// }

static void errorNamedSink(char* varname, SCmethod* mp)
{
  Name mname = mp->snmethod()->selector()->string();
  sprintf(ErrorMessageBuffer,
	  "Variable '%s' in method '%s' has no inlet",
	  varname,
	  (char*)mname);
  SNerror(ErrorMessageBuffer,
	    mp->snmethod()->LineNumber());
}

void markSinks(SCclass* current, SCvarList& targets)
{
  varsInSCclass imports(current);
  for (SCimport* ip = imports() ; ip ; ip = imports.next()) {
    if (targets.find(ip->name())) {
      ip->setSink();
    }
  }
  methodsInSCclass methods(current);
  for (SCmethod* mp = methods() ; mp ; mp = methods.next()) {
    SCvarList methodTargets(targets);
    varsInSCmethod vars(mp);
    for (SCvar* vp = vars() ; vp ; vp = vars.next()) {
      if (!vp->isInlet() && !vp->hasInletOffspring()) {
	// vp  Inlet ǤϤʤInlet λ¹ʤ
	varsInSCclass imports(current);
	SCimport* import = imports.find(vp);
	if (import == 0) {	// vp  Root Ǥ
	  methodTargets.push(vp);
	  errorNamedSink(vp->name(), mp);
	}
	else if (import->isInlet()) { // vp  Inlet Ȥ͢Ƥ
	  if (targets.find(vp) == 0) {
	    methodTargets.push(vp);
	    errorNamedSink(vp->name(), mp);
	  }
	}
      }
    }
    classesInSCmethod classes(mp);
    for (SCclass* clp = classes() ; clp ; clp = classes.next()) {
      markSinks(clp, methodTargets);
    }
  }
}


// void mapImportList(SCclass* current)
// {
//   for (current Τ٤ƤΥ᥽å method ˤĤ) {
//     method  imports ղä;
//     for (method Τ٤ƤΥܥ饿륯饹 class ˤĤ) {
//	 mapImportList(class);
//     }
//   }
// }

void mapImportList(SCclass* current)
{
  methodsInSCclass methods(current);
  for (SCmethod* mp = methods() ; mp ; mp = methods.next()) {
    mp->map(current->importList());
    classesInSCmethod classes(mp);
    for (SCclass* clp = classes() ; clp ; clp = classes.next()) {
      mapImportList(clp);
    }
  }
}

