/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

// SCmethod --- SCope tree node for method

#ifndef SCmethod_h
#define SCmethod_h 1

#include "SCclass.h"
#include "SCvar.h"
#include "gArray.h"
#include "SNmethod.h"
#include "Protocol.h"

declare(gArray, SCclass);
declare(gArray, SCvar);

class SCmethod {
friend class classesInSCmethod;
friend class varsInSCmethod;
  SNmethod* snmtdp;		// Corresponding node in the syntax tree
  SCclass* ownerClass;		// The class this method belongs to
  gArray(SCclass) classes;	// Vector of volatile classes
  gArray(SCvar) vars;		// Vector of variables in this method
public:
  SCmethod(SNmethod*, SCclass* = 0);
  SCclass* owner() { return ownerClass; }
  Name name() { return snmtdp->selector()->string(); }
  SCvar* find(SCvar* key) {	// Return var with the name of the given var
    return find(key->name());
  }
  SCvar* find(char*);		// Return var with the given name
  void print(int = 0);
  void export(SCimport*);
  SNmethod* snmethod() { return snmtdp; }
  void map(gList(SCimport)& imports);
};

struct classesInSCmethod : gArrayItr(SCclass) {
  classesInSCmethod(SCmethod* mtdp) : (mtdp->classes) {}
};

struct varsInSCmethod : gArrayItr(SCvar) {
  varsInSCmethod(SCmethod* mtdp) : (mtdp->vars) {}
};

#endif
