/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include <string.h>
#include <stream.h>
#include "SNvolatile.h"
#include "SNimport.h"
#include "SCmethod.h"
#include "indent.h"

SCmethod::SCmethod(SNmethod* snmp, SCclass* clp)
: snmtdp(snmp),
  ownerClass(clp),
  classes(snmp->volatiles.length()),
  vars(snmp->streams.length())
{
  gList_iterator(SNvolatile) vClasses(&(snmp->get_volatiles()));
  int i = 0;
  for (SNvolatile* vlp = vClasses() ; vlp ; vlp = vClasses.next()) {
    classes[i++] = new SCclass(vlp, this);
  }
  i = 0;
  gMHList_iterator(SNstream) streams(&(snmp->get_streams()));
  for (SNstream* srmp = (SNstream*)streams() ; srmp ; srmp = streams.next()) {
    vars[i++] = new SCvar(srmp);
  }
}

SCvar* SCmethod::find(char* key)
{
  for (int i = 0 ; i < vars.length() ; i++) {
    if (strcmp(vars[i]->name(), key) == 0) return vars[i];
  }
  return 0;
}

void SCmethod::print(int from)
{
  indent space(from);
  cout << space << "begin method\n";
  cout << space << "vars:\n";
  int vfrom = from + 2;
  varsInSCmethod vars(this);
  for (SCvar* vp = vars() ; vp ; vp = vars.next()) {
    cout << " ";
    vp->print(vfrom);
  }
  classesInSCmethod vClasses(this);
  for (SCclass* vcp = vClasses() ; vcp ; vcp = vClasses.next()) {
    vcp->print(vfrom);
  }
  cout << space << "end method\n";
}

void SCmethod::export(SCimport* vp)
{
  SNstream* snsrmp = snmtdp->get_streams().findOrMake(vp->name());
  snsrmp->count(vp->isInlet() ? ORD_INLET : ORD_OUTLET);
}

void SCmethod::map(gList(SCimport)& imports)
//  Υ᥽åɤλΥ饹͢ѿ(imports)б
// importActionäбSNmethodղä롣
//  Υ᥽åɤ鵯ư륯饹͢SNѴ
// бSNclassղä롣
{
  if (imports.length() > 0) {
    // ͢ѿΤsinkǤʤΤȴФ
    gList(SNunit) noSink;
    gList_iterator(SCimport) scimports(&imports);
    for (SCimport* scip = scimports() ; scip ; scip = scimports.next()) {
      SNunit* up = scip->convertToParameter(snmtdp);
      if (up) noSink.add(up);
    }
    // importAction 
    SNimport* snip = new SNimport(noSink.length());
    int i = 0;
    gList_iterator(SNunit) importVars(&noSink);
    for (SNunit* up = importVars() ; up ; up = importVars.next()) {
      (*snip)[i++] = up;
    }
    snmtdp->mapImport(snip);	// SNmethodդ롣
  }
  classesInSCmethod classes(this);
  for (SCclass* clp = classes() ; clp ; clp = classes.next()) {
    clp->mapImportList(snmtdp);
  }
}
