/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SCimport_h
#define SCimport_h 1

#include "OnOff.h"
#include "SCvar.h"
#include "indent.h"

class SNunit;
class SNmethod;

class SCimport {
  char* nameString;
  OnOff InletFlag;
  OnOff sinkFlag;
public:
//  SCimport(char* nm, OnOff bit) : nameString(nm), InletFlag(bit) {}
  SCimport(SCvar* vp) {
    nameString = vp->name();
    InletFlag = sinkFlag = OFF;
  }
  char* name() { return nameString; }
  OnOff isInlet() { return InletFlag == ON; }
  void setInlet(OnOff bit) { InletFlag = bit ; }
  void setSink() { sinkFlag = ON; }
  void print(int from) {
    indent space(from);
    cout << space << (InletFlag ? "^" : " ") << nameString << "\n";
  }
  SNunit* convertToSNvar(SNmethod*);
  SNunit* convertToParameter(SNmethod*);
};

#endif SCimport_h
