/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include "SCimport.h"
#include "SNmethod.h"
#include "SNinlet.h"

SNunit* SCimport::convertToSNvar(SNmethod* snmtdp)
{
  if (sinkFlag == ON) return 0;
  SNstream* snsrmp = snmtdp->get_streams().findOrMake(nameString);
  if (InletFlag == ON)
    return new SNinlet(snsrmp);
  else {
    snsrmp->count(ORD_OUTLET);
    return snsrmp;
  }
}

SNunit* SCimport::convertToParameter(SNmethod* snmtdp)
{
  if (sinkFlag == ON) return 0;
  SNstream* snsrmp = snmtdp->get_streams().findOrMake(nameString);
  if (InletFlag != ON)
    return new SNinlet(snsrmp);
  else {
    snsrmp->count(ORD_OUTLET);
    return snsrmp;
  }
}
