/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

// SCclass --- SCope tree node for class

#ifndef SCclass_h
#define SCclass_h 1

#include "gList.h"
#include "gArray.h"
#include "SCimport.h"
#include "SNvolatile.h"

class SNclass;
class SNmethod;
class SCmethod;

declare(gList, SCimport);
declare(gArray, SCmethod);

class SCclass {
friend class methodsInSCclass;
friend class varsInSCclass;
  SNclass* snclass;	// Corresponding node in syntax tree
//  SNclass* snclass;		// Another corresponding node in syntax tree
  SCmethod* callerMethod;	// Method this class is called from
  gArray(SCmethod) methods;	// Vector of methods
  gList(SCimport) imports;	// Vector of variables shared by this
				// class and its parents

  void init(SNclass*, SCmethod*);   // common part of initialization
public:
  SCclass(SNclass*, SCmethod* = 0);
//  SCclass(SNvolatile*, SCmethod* = 0);
  char* name() { return snclass->get_name(); }
  SCmethod*& caller() { return callerMethod; }
  SCmethod*& method(int i) { return methods[i]; }
  SCimport* find(SCvar*);	// Return var having the same name as given var
  void import(SCvar* vp);	// Register a variable as imported
  gList(SCimport)& importList() { return imports; }
  void print(int = 0);
  void mapImportList(SNmethod*);
};

#include "SNclass.h"

inline SCclass::SCclass(SNclass* sncp, SCmethod* mp)
: snclass(sncp),
  methods(sncp->get_methods().length())
{
  init(sncp, mp);
}

struct methodsInSCclass : gArrayItr(SCmethod) {
  methodsInSCclass(SCclass* clp) : (clp->methods) {}
};

struct varsInSCclass : gList_iterator(SCimport) {
  varsInSCclass(SCclass* clp) : (&(clp->imports)) {}
  SCimport* find(SCvar*);
};

#endif
