/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include <string.h>
#include <stream.h>
#include "SNclass.h"
#include "SNmethod.h"
#include "SNexport.h"
#include "SCclass.h"
#include "SCmethod.h"
#include "SCvar.h"
#include "indent.h"
#include "SN2SC.h"


void SCclass::init(SNclass* sncp, SCmethod* mp)
{
//  snclass = sncp;
  callerMethod = mp;
  gList_iterator(SNmethod) SNmethods(&(sncp->get_methods()));
  int i = 0;
  for (SNmethod* mdp = SNmethods() ; mdp ; mdp = SNmethods.next()) {
    methods[i++] = convert(mdp, this);
  }
}

SCimport* SCclass::find(SCvar* key)
{
  gList_iterator(SCimport) varIt(&imports);
  for (SCimport* vp = varIt() ; vp ; vp = varIt.next()) {
    if (strcmp(vp->name(), key->name()) == 0) return vp;
  }
  return 0;
}

void SCclass::import(SCvar* vp)
{
  if (!find(vp)) {
    imports.add(new SCimport(vp));
  }
}

void SCclass::print(int from)
{
  indent space(from);
  cout << space << "begin class\n";
  cout << space << "imported vars:\n";
  int vfrom = from + 2;
  varsInSCclass vars(this);
  for (SCimport* vp = vars() ; vp ; vp = vars.next()) {
    vp->print(vfrom);
  }
  int mfrom = from + 2;
  methodsInSCclass methods(this);
  for (SCmethod* mp = methods() ; mp ; mp = methods.next()) {
    mp->print(mfrom);
  }
  cout << space << "end class\n";
}

// SCclass::mapImportList() ϼΣĤνԤ
//  SNimport ȤƵϿƤ͢ѿ, SNбǤ
//    Ѵ롣κݡб SNvolatile ƤӽФƤ᥽åɤ
//     SNstream ͢ѿʬνиȤä롣
//  б SNvolatile ͢ѿꥹȤղä롣

void SCclass::mapImportList(SNmethod* snmtdp)
{
  gList(SNunit) noSink;
  gList_iterator(SCimport) scimports(&imports);
  for (SCimport* scip = scimports() ; scip ; scip = scimports.next()) {
    SNunit* up = scip->convertToSNvar(snmtdp);
    if (up) noSink.add(up);
  }
  SNexport* snep = new SNexport(noSink.length());
  int i = 0;
  gList_iterator(SNunit) exportVars(&noSink);
  for (SNunit* up = exportVars() ; up ; up = exportVars.next()) {
    snep->setVar(i++, up);
  }
  ((SNvolatile*)snclass)->export(snep);
}

SCimport* varsInSCclass::find(SCvar* scvp)
{
  for (reset() ; (*this)() ; step()) {
    if (strcmp((*this)()->name(), scvp->name()) == 0)
      return (*this)();
  }
  return 0;
}
