/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef RegTable_h
#define RegTable_h 1

#include <bool.h>
#include "OnOff.h"
#include "Rind.h"

class intList;

class RegTableEntry {
friend class RegTable;
friend class MovTable;

  int count;
  int bottom;
  OnOff closeFlag;

  void set(int n, OnOff f) { count = n; closeFlag = f; }
  void add(int n, OnOff f) { count += n; closeFlag |= f; }
  void setBottom() { bottom = count - 1; }
  void decrement();
  void increment() { ++count; }
  int needClose() { return (count == bottom && closeFlag); }

public:
  RegTableEntry(int c = 0, OnOff f = OFF)
    : count(c), bottom(0), closeFlag(f) {}
  RegTableEntry(RegTableEntry& ent)
    : count(ent.count), bottom(ent.bottom), closeFlag(ent.closeFlag) {}
  bool inUse() { return count > 0; }
};

const int RegTableSize = 64;

class RegTable {
friend class MovTable;

  RegTableEntry ents[RegTableSize];

public:
  void set(Rind r, int n = 1, OnOff f = OFF) { ents[r].set(n, f); }
  void add(Rind r, int n, OnOff f = OFF) { ents[r].add(n, f); }
  void setBottom(Rind r) { ents[r].setBottom(); }
  RegTableEntry* save(Rind);
  void restore(Rind, RegTableEntry*);
  void decrement(Rind r) { ents[r].decrement(); }
  void increment(Rind r) { ents[r].increment(); }
  bool isLastAppearance(Rind r) {
    return (ents[r].count == 1) ;
  }
  int needClose(Rind r) { return ents[r].needClose(); }
  void init(int = 0);
  Rind newReg();
  void connected(Rind);
  intList* regsInUse();
};

extern RegTable regTable;

#endif RegTable_h
