/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include <stream.h>
#include <stdlib.h>
#include <assert.h>
#include "RegTable.h"
#include "intList.h"

RegTable regTable;

void RegTableEntry::decrement()
{
  --count;
}

void RegTable::init(int n)
{
  if (n >= RegTableSize) {
    cerr << "Too many selector arguments.";
    exit(1);
  }
  for (int i = 0 ; i < n ; i++) set(i, 1);
  for ( ; i < RegTableSize ; i++) set(i, 0);
}

Rind RegTable::newReg()
{
  for (int i = 0 ; i < RegTableSize ; i++) {
    assert(ents[i].count >= 0);
    if (ents[i].count == 0) return i;
  }
  cerr << "Registers used up.\n";
  exit(1);
  // not reached; the following line is a dummy
  return -1;
}

void RegTable::connected(Rind to)
{
  ents[to].decrement();
  ents[to].closeFlag = OFF;
}

intList* RegTable::regsInUse()
{
  intList* regs = new intList;
  for (int i = 0 ; i < RegTableSize ; i++) {
    if (ents[i].count != 0) regs->add(i + 1);
  }
  return regs;
}

RegTableEntry* RegTable::save(Rind r)
{
  return new RegTableEntry(ents[r]);
}

void RegTable::restore(Rind r, RegTableEntry* newent)
{
  ents[r] = *newent;
}
