/* -*- fundamental -*- */

%{

#include <std.h>
#include <bool.h>
#include <signal.h>
#include <assert.h>

#include "SNname.h"
#include "SNunitList.h" /* åȤƻȤ				*/
			/* 󥹥å˼ؤɬפ롣	*/
#include "SNclass.h"
#include "SNmethod.h"
#include "SNfgnmtd.h"
#include "SNmessage.h"
#include "SNclosed.h"
#include "SNdefmsg.h"
#include "SNnil.h"
#include "SNint.h"
#include "SNfloat.h"
#include "SNdouble.h"
#include "SNbool.h"
#include "SNstring.h"
#include "SNbnkstr.h"
#include "SNlist.h"
#include "SNvector.h"
#include "SNfvector.h"
#include "SNoslot.h"
#include "SNislot.h"
#include "SNself.h"
#include "SNsink.h"
#include "SNsend.h"
#include "SNsendself.h"
#include "SNconnect.h"
#include "SNappend.h"
#include "SNnew.h"
#include "SNminus.h"
#include "SNstream.h"
#include "SNinlet.h"
#include "SNorder.h"
#include "SNplain.h"
#include "SNerror.h"
#include "SNwho.h"
#include "SNcaro.h"
#include "SNscaro.h"
#include "SNcdro.h"
#include "SNscdro.h"
#include "SNelto.h"
#include "SNseto.h"
#include "SNclassof.h"
#include "SNissimple.h"
#include "SNisbuiltin.h"
#include "SNnot.h"
#include "SNsislot.h"
#include "SNsoslot.h"
#include "SNsioslot.h"
#include "SNlt.h"
#include "SNgt.h"
#include "SNle.h"
#include "SNge.h"
#include "SNor.h"
#include "SNxor.h"
#include "SNand.h"
#include "SNequal.h"
#include "SNnequal.h"
#include "SNshtl.h"
#include "SNshtr.h"
#include "SNplus.h"
#include "SNsub.h"
#include "SNmul.h"
#include "SNdiv.h"
#include "SNmod.h"
#include "SNanonout.h"
#include "SNanonin.h"
#include "Protocol.h"
#include "closePcol.h"
#include "defPcol.h"
#include "errmsg.h"
#include "SCclass.h"
#include "SNtcs.h"
#include "parse.h"
#include "aumc.h"

extern "C" {
#include "lex.h"
}

// private:
SNstreamList* streams_ptr;
SNmethod* method_ptr;
SNfgncallList* fgncalls_ptr;
FgnArgSpecList* fgnArgList_ptr;
enum bool supersAreDeclared;
enum bool islotsAreDeclared;
enum bool oslotsAreDeclared;
gList(SNunit) parseStack;
SNtreeContextStack SNtreeContextStack;

static SNclass* outermostClass();
static bool validInletSlotname(SNname*);
static bool validOutletSlotname(SNname*);

// public:
SNclass* class_ptr;
int numberOfErrors;

#define newSNunit1(CLASS,ARG1)			\
	    CLASS* cp = new CLASS(ARG1);	\
	    cp->LineNumber(numberOfLines);	\
	    yyval.asSNunit = cp

#define newSNunit2(CLASS,ARG1,ARG2)		\
	    CLASS* cp = new CLASS(ARG1, ARG2);	\
	    cp->LineNumber(numberOfLines);	\
	    yyval.asSNunit = cp

%}

%union {
  char* asString;
  long	asInteger;
  double asDouble;
  SNunit* asSNunit;
  SNname* asName;
}

%token Class_beginner		/* class */
%token Class_ender		/* end */
%token Super_class_declarer	/* super */
%token Inlet_slot_declarer	/* in */
%token Outlet_slot_declarer	/* out */
%token Foreign_call_declarer	/* foreign_call */
%token Foreign_proc_declarer	/* call */
%token Foreign_arg_declarer	/* arg */
%token Foreign_result_declarer	/* result */
%token Foreign_retval_declarer	/* return */
%token <asNeck> Descending_neck	    /* -> */
%token <asNeck> Terminating_neck    /* -| */
%token Closed_interface		/* :: */
%token Equal			/* == */
%token Nequal			/* != */
%token GE			/* >= */
%token LE			/* =< */
%token Right_shift		/* >> */
%token Left_shift		/* << */
%token Class_object_mark	/* ## */
%token Create_locally		/* #@ */
%token Car			/* car */
%token Cdr			/* cdr */
%token Mod			/* mod */
%token Or			/* or */
%token Xor			/* xor */
%token And			/* and */
%token Not			/* not */
%token Classof			/* classof */
%token IsSimple			/* issimple */
%token IsBuiltin		/* isbuiltin */
%token Self			/* $self */
%token Sink			/* $sink */
%token <asString> Identifier	/* symbol, slot name, etc. */
%token <asString> EscapedIdentifier /* quoted names */
%token <asString> String	/* string */
%token <asString> Capital	/* stream variable name */
%token <asInteger> Integer	/* integer number */
%token <asInteger> Character	/* character code */
%token <asDouble> Float		/* floating point number */
%token <asDouble> Double	    /* floating point number */
%token <asInteger> Boolean	/* boolean value */

%type <asInteger> method_neck list_elements vector_elements
%type <asInteger> message_arguments self_send
%type <asName> identifier
%type <asSNunit> volatile_class_definition vclass_interface
%type <asSNunit> method_head
%type <asInteger> foreign_linkage_specification
%type <asInteger> foreign_type_spec
%type <asSNunit> foreign_retval_declaration
%type <asSNunit> selector message message_head message_sent
%type <asSNunit> action literal expression
%type <asSNunit> inlet_assignment outlet_assignment
%type <asSNunit> double_assignment
%type <asSNunit> or_expression xor_expression and_expression
%type <asSNunit> equality_expression relational_expression
%type <asSNunit> shift_expression additive_expression
%type <asSNunit> multiplicative_expression unary_expression
%type <asSNunit> postfix_expression minus_expression primary_expression
%type <asSNunit> list list_cdr
%type <asSNunit> outlet inlet
%type <asSNunit> anon_outlet_variable anon_inlet_variable
%type <asSNunit> outlet_variable plain_variable ordered_variable
%type <asSNunit> inlet_variable
%type <asSNunit> atom string integer character float double
%type <asSNunit> boolean vector
    /* %type class_literal */
%type <asSNunit> outlet_slot inlet_slot
%type <asSNunit> pseudo_variable
%type <asSNunit> instance_creation, local_instance_creation
%type <asSNunit> who_expression

%start program

%%

program	    :	    /* empty */
	    |	program
		{
		    classrefTable->clear();
		    protocolTable->clear();

		    Protocol* pp = new Protocol("`true", 0);
		    SNcond::trueProtocol = pp->intern();
		    assert(SNcond::trueProtocol == pp);

		    pp = new Protocol("`false", 0);
		    SNcond::falseProtocol = pp->intern();
		    assert(SNcond::falseProtocol == pp);

		    closeProtocol::uniqueInstance = new closeProtocol();
		    defaultProtocol::uniqueInstance = new defaultProtocol();
		}
		class_definition
	    ;

class_definition
	    :	class_header
		{
		    /* attribute_declarations  parse Τν */
		    supersAreDeclared = FALSE;
		    islotsAreDeclared = FALSE;
		    oslotsAreDeclared = FALSE;
		}
		attribute_declarations
		method_definitions
		class_footer
		{
		    class_ptr->fgnCalls(fgncalls_ptr);
#ifdef NEEDCOREDUMP
		    resetSignalHandlers();
#endif
		    compile();
#ifdef NEEDCOREDUMP
		    setSignalHandlers();
#endif
		    delete class_ptr;
		    class_ptr = 0;
		    currentClassName = unsetClassName;
		}
	    |	error	class_footer
		{
		    delete class_ptr;
		    class_ptr = 0;
		    yyerrok;
		}
	    ;

class_header
	    :	Class_beginner identifier '.'
		{
		    class_ptr = new SNclass($2);
		    class_ptr->LineNumber(numberOfLines);
		    currentClassName = *$2;
		    fgncalls_ptr = 0;
		}
	    ;

identifier  :	Identifier
		{
		    SNname* np = new SNname($1);
		    np->LineNumber(numberOfLines);
		    $$ = np;
		    disposeString($1);
		}
	    |	EscapedIdentifier
		{
		    SNname* np = new SNname($1, EMescaped);
		    np->LineNumber(numberOfLines);
		    $$ = np;
		    disposeString($1);
		}
	    ;

attribute_declarations
	    :	/* empty */
	    |	attribute_declarations attribute_declaration
	    ;

attribute_declaration
	    :	super_class_declaration
	    |	inlet_slot_declaration
	    |	outlet_slot_declaration
	    ;

super_class_declaration
	    :	Super_class_declarer
		{
		    if (supersAreDeclared) {
			yyerror("keyword 'super' appears twice");
			YYERROR;
		    }
		    supersAreDeclared = TRUE;
		}
		super_class_names '.'
	    ;

super_class_names
	    :	identifier
		{
		    SNnameList& supers = class_ptr->get_supers();
		    if (supers.member(*$1)) {
			sprintf(ErrorMessageBuffer,
				"super class '%s' redeclared", (char*)*$1);
			yyerror(ErrorMessageBuffer);
			YYERROR;
		    }
		    supers.add($1);
		}
	    |	super_class_names ',' identifier
		{
		    SNnameList& supers = class_ptr->get_supers();
		    if (supers.member(*$3)) {
			sprintf(ErrorMessageBuffer,
				"super class '%s' redeclared", (char*)*$3);
			yyerror(ErrorMessageBuffer);
			YYERROR;
		    }
		    supers.add($3);
		}
	    ;

inlet_slot_declaration
	    :	Inlet_slot_declarer
		{
		    if (islotsAreDeclared) {
			yyerror("keyword 'in' appears twice");
			YYERROR;
		    }
		    islotsAreDeclared = TRUE;
		}
		inlet_slot_names '.'
	    ;

inlet_slot_names
	    :	identifier
		{
		    SNnameList& islots = class_ptr->get_islots();
		    if (islots.member(*$1)) {
			sprintf(ErrorMessageBuffer,
				"inlet slot '%s' redeclared", (char*)*$1);
			yyerror(ErrorMessageBuffer);
			YYERROR;
		    }
		    islots.add($1);
		}
	    |	inlet_slot_names ',' identifier
		{
		    SNnameList& islots = class_ptr->get_islots();
		    if (islots.member(*$3)) {
			sprintf(ErrorMessageBuffer,
				"inlet slot '%s' redeclared", (char*)*$3);
			yyerror(ErrorMessageBuffer);
			YYERROR;
		    }
		    islots.add($3);
		}
	    ;

outlet_slot_declaration
	    :	Outlet_slot_declarer
		{
		    if (oslotsAreDeclared) {
			yyerror("keyword 'out' appears twice");
			YYERROR;
		    }
		    oslotsAreDeclared = TRUE;
		}
		outlet_slot_names '.'
	    ;

outlet_slot_names
	    :	identifier
		{
		    SNnameList& oslots = class_ptr->get_oslots();
		    if (oslots.member(*$1)) {
			sprintf(ErrorMessageBuffer,
				"outlet slot '%s' redeclared", (char*)*$1);
			yyerror(ErrorMessageBuffer);
			YYERROR;
		    }
		    oslots.add($1);
		}
	    |	outlet_slot_names ',' identifier
		{
		    SNnameList& oslots = class_ptr->get_oslots();
		    if (oslots.member(*$3)) {
			sprintf(ErrorMessageBuffer,
				"outlet slot '%s' redeclared", (char*)*$3);
			yyerror(ErrorMessageBuffer);
			YYERROR;
		    }
		    oslots.add($3);
		}
	    ;

method_definitions
	    :	/* empty */
	    |	method_definitions method_definition
		{   method_ptr = 0; }
	    ;

method_definition
	    :	domestic_method_definition
		{
		    class_ptr->get_methods().add(method_ptr);
		}
	    |	foreign_method_definition
		{
		    class_ptr->get_methods().add(method_ptr);
		}
	    |	error '.'
		{
		    if (method_ptr) delete method_ptr;
		    method_ptr = 0;
		    yyerrok;
		}
	    ;

domestic_method_definition
	    :	method_head
		method_neck
		{
		    method_ptr = new SNmethod(*streams_ptr);
		    method_ptr->setSelector((SNmessage*)$1);
		    method_ptr->setDescend($2);
		}
		actions
		'.'
	    ;

foreign_method_definition
	    :	method_head
		Foreign_call_declarer
		foreign_linkage_specification
		Foreign_proc_declarer String
		foreign_arg_declaration
		foreign_retval_declaration
		'.'
		{
		    FgnLinkType flt = (enum FgnLinkType)$3;
		    SNfgncall* fgncallp
			= new SNfgncall(FgnLinkage::instance(flt),
					(char*)$5,  /* proc name */
					fgnArgList_ptr,
					(FgnRetValSpec*)$7);
		    fgncallp->LineNumber(numberOfLines);
		    if (fgncalls_ptr == 0) {
			fgncalls_ptr = new SNfgncallList;
		    }
		    fgncalls_ptr->add(fgncallp);
		    method_ptr = new SNmethod(*streams_ptr);
		    method_ptr->setSelector((SNmessage*)$1);
		    method_ptr->setDescend(M_DESCEND);
		    fgncallp->transform(method_ptr);
		}
	    ;

method_head :	{   streams_ptr = new SNstreamList();	}
		selector
		{
		    SNmessage* selector = (SNmessage*)$2;
		    SNmethodListItr methods(class_ptr->get_methods());
		    if (methods.member(selector->protocol())) {
			Name pcolname = selector->protocol()->string();
			sprintf(ErrorMessageBuffer,
				"method '%s' redefined",
				(char*)pcolname);
			yyerror(ErrorMessageBuffer);
			YYERROR;
		    }
		    $$ = selector;
		}
	    ;

foreign_linkage_specification
	    :	String
		{
		    if (strcmp($1, "C") == 0) {
			$$ = (int)FgnLinkTypeC;
		    }
		    else if (strcmp($1, "C++") == 0) {
			sprintf(ErrorMessageBuffer,
			    "sorry, C++ linkage is not supported yet");
			yyerror(ErrorMessageBuffer);
			YYERROR;
		    }
		    else {
			sprintf(ErrorMessageBuffer,
				"invalid linkage specifier '%s'",
				(char*)$1);
			yyerror(ErrorMessageBuffer);
			YYERROR;
		    }
		}
	    ;

foreign_arg_declaration
	    :	/* empty */
		{   fgnArgList_ptr = 0; }
	    |	Foreign_arg_declarer
		{   fgnArgList_ptr = new FgnArgSpecList();  }
		foreign_arglist
	    ;

foreign_arglist
	    :	foreign_arg_spec
	    |	foreign_arglist ';' foreign_arg_spec
	    ;

foreign_arg_spec
	    :	outlet_variable ':' foreign_type_spec
		{
		    FgnValArgSpec* asp = new FgnValArgSpec($1,
						(enum ForeignType)$3);
		    asp->LineNumber(numberOfLines);
		    fgnArgList_ptr->add(asp);
		}
	    |	outlet_variable ':' foreign_type_spec
		Foreign_result_declarer inlet_variable
		{
		    FgnVarArgSpec* asp = new FgnVarArgSpec($1,
					    (enum ForeignType)$3,
					    $5);
		    asp->LineNumber(numberOfLines);
		    fgnArgList_ptr->add(asp);
		}
	    ;

foreign_retval_declaration
	    :	/* empty */
		{   $$ = (void*)0;  }
	    |	Foreign_retval_declarer inlet_variable ':' foreign_type_spec
		{
		    newSNunit2(FgnRetValSpec, $2, (enum ForeignType)$4);
		}
	    ;

foreign_type_spec
	    :	Identifier
		{
		    if (strcmp($1, "integer") == 0) $$ = FgnTypeInteger;
		    else if (strcmp($1, "double_float") == 0)
			 $$ = FgnTypeDouble;
		    else if (strcmp($1, "string") == 0) $$ = FgnTypeString;
		    else if (strcmp($1, "foreign") == 0) $$ = FgnTypeForeign;
		    else {
			sprintf(ErrorMessageBuffer,
				"invalid foreign type specifier '%s'",
				(char*)$1);
			yyerror(ErrorMessageBuffer);
			YYERROR;
		    }
		}
	    ;

selector    :	Closed_interface    /* :: */
		{   $$ = new SNclosed(); }
	    |	inlet		/* ^Message */
		{
		    $$ = (new SNdefmsg($1))->operator SNunit*();
		}
	    |	message
		{
		    SNmessage* mp = (SNmessage*)$1;
		    Protocol* pp = new Protocol(mp);
		    pp->flip();
		    Protocol* ipp = pp->intern();
		    mp->setProtocol(ipp == pp ? pp : (delete pp, ipp));
		}
	    ;

message	    :	':' literal
		{   newSNunit2(SNmessage, $2, 0);   }
	    |	':' message_head '(' message_arguments ')'
		{
		    SNmessage* mp = new SNmessage($2, $4);
		    mp->LineNumber(numberOfLines);
		    for (int i = $4 - 1 ; i >= 0 ; i--) {
			(*mp)[i] = parseStack.pop();
		    }
		    $$ = mp;
		}
	    ;

literal	    :	integer
	    |	'+' Integer
		{   newSNunit1(SNint, $2);  }
	    |	'-' Integer
		{   newSNunit1(SNint, (-$2));	}
	    |	float
	    |	'+' Float
		{   newSNunit1(SNfloat, float($2)); }
	    |
		'-' Float
		{   newSNunit1(SNfloat, float(-$2));	}
	    |	atom
	    |	boolean
	    |	character
	    ;


message_head
	    :	/* empty */
		{   $$ = 0;	}
	    |	atom
		{   $$ = $1;	}
	    ;

message_arguments
	    :	expression
		{
		    parseStack.push($1);
		    $$ = 1;
		}
	    |	message_arguments ',' expression
		{
		    parseStack.push($3);
		    $$ = $1 + 1;
		}
	    ;

method_neck :	Descending_neck	    /* -> */
		{   $$ = M_DESCEND; }
	    |	Terminating_neck    /* -| */
		{   $$ = M_TERMINATE;	}
	    ;

actions	    :	/* empty */
	    |	action
		{
		    method_ptr->get_actions().add($1);
		}
	    |	actions ',' action
		{
		    method_ptr->get_actions().add($3);
		}
	    ;

action	    :	expression
	    |	inlet_assignment
	    |	double_assignment
	    |	self_send
		{
		    SNsendself* sendselfp = new SNsendself($1);
		    sendselfp->LineNumber(numberOfLines);
		    for (int i = $1 - 1 ; i >= 0 ; i--) {
			sendselfp->arg(i) = (SNmessage*)parseStack.pop();
		    }
		    $$ = sendselfp;
		}
	    |	volatile_class_definition
	    ;

expression  :	outlet
	    |	inlet
	    ;

outlet	    :	or_expression
	    |	outlet '=' inlet
		{   newSNunit2(SNconnect, $3, $1);  }
	    |	outlet '\\' inlet
		{   newSNunit2(SNappend, $3, $1);   }
	    |	outlet_assignment
	    ;

or_expression
	    :	xor_expression
	    |	or_expression Or xor_expression
		{   newSNunit2(SNor, $1, $3);	}
	    ;

xor_expression
	    :	and_expression
	    |	xor_expression Xor and_expression
		{   newSNunit2(SNxor, $1, $3); }
	    ;

and_expression
	    :	equality_expression
	    |	and_expression And equality_expression
		{   newSNunit2(SNand, $1, $3);	}
	    ;

equality_expression
	    :	relational_expression
	    |	relational_expression Equal relational_expression
		{   newSNunit2(SNequal, $1, $3);    }
	    |	relational_expression Nequal relational_expression
		{   newSNunit2(SNnequal, $1, $3);   }
	    ;

relational_expression
	    :	shift_expression
	    |	shift_expression '<' shift_expression
		{   newSNunit2(SNlt, $1, $3);	}
	    |	shift_expression '>' shift_expression
		{   newSNunit2(SNgt, $1, $3);	}
	    |	shift_expression GE shift_expression
		{   newSNunit2(SNge, $1, $3);	}
	    |	shift_expression LE shift_expression
		{   newSNunit2(SNle, $1, $3);	}
	    ;

shift_expression
	    :	additive_expression
	    |	shift_expression Right_shift additive_expression
		{   newSNunit2(SNshtr, $1, $3); }
	    |	shift_expression Left_shift additive_expression
		{   newSNunit2(SNshtl, $1, $3); }
	    ;

additive_expression
	    :	multiplicative_expression
	    |	additive_expression '+' multiplicative_expression
		{   newSNunit2(SNplus, $1, $3); }
	    |	additive_expression '-' multiplicative_expression
		{   newSNunit2(SNsub, $1, $3);	}
	    ;

multiplicative_expression
	    :	unary_expression
	    |	multiplicative_expression '*' unary_expression
		{   newSNunit2(SNmul, $1, $3);	}
	    |	multiplicative_expression '/' unary_expression
		{   newSNunit2(SNdiv, $1, $3);	}
	    |	multiplicative_expression Mod unary_expression
		{   newSNunit2(SNmod, $1, $3);	}
	    ;

unary_expression
	    :	postfix_expression
	    |	Not unary_expression
		{   newSNunit1(SNnot, $2);  }
	    |	Car unary_expression
		{   newSNunit1(SNcaro, $2); }
	    |	Cdr unary_expression
		{   newSNunit1(SNcdro, $2); }
	    |	Classof unary_expression
		{   newSNunit1(SNclassof, $2);	}
	    |	IsSimple unary_expression
		{   newSNunit1(SNissimple, $2); }
	    |	IsBuiltin unary_expression
		{   newSNunit1(SNisbuiltin, $2);    }
    /*	    |	mathematical_operator unary_expression	*/
	    ;

postfix_expression
	    :	minus_expression
	    |	postfix_expression message_sent
		{   newSNunit2(SNsend, $1, ((SNmessage*)$2));	}
	    |	postfix_expression '[' outlet ']'
		{   newSNunit2(SNelto, $1, $3); }
	    ;

minus_expression
	    :	primary_expression
	    |	'-' primary_expression
		{   newSNunit1(SNminus, $2);	}
	    ;

primary_expression
	    :	integer
	    |	float
	    |	double
	    |	atom
	    |	boolean
	    |	character
	    |	string
	    |	list
	    |	vector
	    |	outlet_variable
	    |	outlet_slot
	    |	pseudo_variable
	    |	'(' outlet ')'
		{   $$ = $2;	}
	    |	instance_creation
	    |	local_instance_creation
	    |	anon_outlet_variable
	    ;

integer	    :	Integer
		{   newSNunit1(SNint, $1);  }
	    ;

float	    :	Float
		{   newSNunit1(SNfloat, float($1)); }
	    ;

double	    :	Double
		{   newSNunit1(SNdouble, $1);	}
	    ;

atom	    :	Identifier
		{
		    newSNunit1(SNsymbol, $1);
		    disposeString($1);
		}
	    |	EscapedIdentifier
		{
		    newSNunit2(SNsymbol, $1, EMescaped);
		    disposeString($1);
		}
	    ;

boolean	    :	Boolean
		{   newSNunit1(SNbool, $1); }
	    ;

character   :	Character
		{   newSNunit1(SNint, $1);  }
	    ;

string	    :	String
		{
		    newSNunit1(SNstring, $1);
		    disposeString($1);
		}
	    ;

list	    :	'[' ']'
		{
		    $$ = SNnil;
		}
	    |	'[' list_elements list_cdr ']'
		{
		    SNlist* listp = new SNlist($2);
		    listp->LineNumber(numberOfLines);
		    listp->cdr = $3;
		    for (int i = $2 - 1 ; i >= 0 ; i--) {
			(*listp)[i] = parseStack.pop();
		    }
		    $$ = listp;
		}
	    ;

list_elements
	    :	expression
		{
		    parseStack.push($1);
		    $$ = 1;
		}
	    |	list_elements ',' expression
		{
		    parseStack.push($3);
		    $$ = $1 + 1;
		}
	    ;

list_cdr    :	/* empty */
		{   $$ = SNnil; }
	    |	'|' expression
		{   $$ = $2;	}
	    ;

vector	    :	'{' vector_elements '}'
		{
		    SNfilledvector* vectorp = new SNfilledvector($2);
		    for (int i = $2 - 1 ; i >= 0 ; i--) {
			(*vectorp)[i] = parseStack.pop();
		    }
		    $$ = vectorp;
		}
	    ;

vector_elements
	    :	/* empty */
		{   $$ = 0; }
	    |	expression
		{
		    parseStack.push($1);
		    $$ = 1;
		}
	    |	vector_elements ',' expression
		{
		    parseStack.push($3);
		    $$ = $1 + 1;
		}
	    ;

outlet_variable
	    :	plain_variable
	    |	ordered_variable
	    ;

plain_variable
	    :	Capital
		{
		    SNstream* SNsrmp = streams_ptr->findOrMake($1);
		    SNsrmp->count(ORD_OUTLET);
		    SNplain* pp = new SNplain($1);
		    pp->LineNumber(numberOfLines);
		    pp->setStream(SNsrmp);
		    $$ = pp;
		}
	    ;

ordered_variable
	    :	Capital '$' Integer
		{
		    SNstream* SNsrmp = streams_ptr->findOrMake($1);
		    SNsrmp->count($3);
		    SNorder* op = new SNorder($1, $3);
		    op->LineNumber(numberOfLines);
		    op->setStream(SNsrmp);
		    $$ = op;
		}
	    ;

outlet_slot
	    :	'!' identifier
		{
		    if (validOutletSlotname($2)) {
			newSNunit1(SNoslot, $2);
		    }
		    else YYERROR;
		}
	    ;

pseudo_variable
	    :	Self
		{
		    SNself* sp = new SNself();
		    sp->LineNumber(numberOfLines);
		    $$ = sp;
		}
	    |	Sink
		{
		    SNsink* sp = new SNsink();
		    sp->LineNumber(numberOfLines);
		    $$ = sp;
		}
	    ;

self_send   :	message_sent
		{
		    $$ = 1;
		    parseStack.push($1);
		}
	    |	self_send message_sent
		{
		    $$ = $1 + 1;
		    parseStack.push($2);
		}
    /*	    |	':' outlet_variable */
	    ;

message_sent
	    :	message
		{
		    SNmessage* mp = (SNmessage*)$1;
		    Protocol* pp = new Protocol(mp);
		    Protocol* ipp = pp->intern();
		    mp->setProtocol(ipp == pp ? pp : (delete pp, ipp));
		    mp->LineNumber(numberOfLines);
		    $$ = mp;
		}
	    ;

instance_creation
	    :	'#' identifier
		{   newSNunit1(SNnew, $2);  }
	    |	'#' identifier '(' outlet ')'
		{
		    if (strcmp(*$2, "vector") == 0) {
			newSNunit1(SNvector, $4);
		    }
		    else if (strcmp(*$2, "string") == 0) {
			newSNunit1(SNblankString, $4);
		    }
		    else {
			    sprintf(ErrorMessageBuffer,
				    "instance creation for classes "
				    "other than 'vector' and 'string' takes "
				    "no argument");
			    yyerror(ErrorMessageBuffer);
			    YYERROR;
		    }
		}
	    ;

local_instance_creation
	    :	Create_locally identifier
		{   newSNunit2(SNnew, $2, SNnew::local);    }
	    |	Create_locally identifier '(' outlet ')'
		{
		    if (strcmp(*$2, "vector") == 0) {
			newSNunit1(SNvector, $4);
		    }
		    else if (strcmp(*$2, "string") == 0) {
			newSNunit1(SNblankString, $4);
		    }
		    else {
			    sprintf(ErrorMessageBuffer,
				    "invalid instance size specification "
				    "for class '%s'",
				    (char*)*$2);
			    yyerror(ErrorMessageBuffer);
			    YYERROR;
		    }
		}
	    ;

anon_outlet_variable
	    :	'_'
		{   $$ = SNanonout::instance(); }
	    ;

inlet	    :	inlet_slot
	    |	inlet_variable
	    |	who_expression
	    |	anon_inlet_variable
	    |	'(' inlet ')'
		{   $$ = $2; }
	    ;

inlet_slot  :	'@' identifier
		{
		    if (validInletSlotname($2)) {
			newSNunit1(SNislot, $2);
		    }
		    else YYERROR;
		}
	    ;

inlet_variable
	    :	'^' Capital
		{
		    SNstream* SNsrmp = streams_ptr->findOrMake($2);
		    if (SNsrmp->count(ORD_INLET) < 0) {
			sprintf(ErrorMessageBuffer,
				"variable '%s' has two inlets", $2);
			yyerror(ErrorMessageBuffer);
			YYERROR;
		    }
		    SNinlet* ip = new SNinlet($2);
		    ip->LineNumber(numberOfLines);
		    ip->setStream(SNsrmp);
		    $$ = ip;
		}
	    ;

who_expression
	    :	postfix_expression '?'
		{   newSNunit1(SNwho, $1);  }
	    ;

anon_inlet_variable
	    :	'^' '_'
		{   $$ = SNanonin::instance();	}
	    ;

inlet_assignment
	    :	'@' identifier '=' inlet
		{
		    if (validInletSlotname($2)) {
			newSNunit2(SNsislot, $2, $4);
		    }
		    else YYERROR;
		}
	    ;

outlet_assignment
	    :	outlet '=' '!' identifier
		{
		    if (validOutletSlotname($4)) {
			newSNunit2(SNsoslot, $4, $1);
		    }
		    else YYERROR;
		}
	    |	outlet '=' postfix_expression '[' outlet ']'
		{
		    SNseto* sp = new SNseto($3, $5, $1);
		    sp->LineNumber(numberOfLines);
		    $$ = sp;
		}
	    |	outlet '=' Car unary_expression
		{   newSNunit2(SNscaro, $4, $1);    }
	    |	outlet '=' Cdr unary_expression
		{   newSNunit2(SNscdro, $4, $1);    }
	    ;

double_assignment
	    :	'@' identifier '=' '!' identifier
		{
		    if (validInletSlotname($2) && validOutletSlotname($5)) {
			newSNunit2(SNsioslot, $2, $5);
		    }
		    else YYERROR;
		}
	    ;

volatile_class_definition
	    :	vclass_interface
		{
		    SNtreeContextStack.save(class_ptr,
					    method_ptr);
		    class_ptr = new SNvolatile($1);
		    class_ptr->LineNumber(numberOfLines);
		}
		'('
		method_definitions
		')'
		{
		    SNvolatile* vcp = (SNvolatile*)class_ptr;
		    SNtreeContextStack.restore(class_ptr,
					       method_ptr);
		    streams_ptr = &(method_ptr->get_streams());
		    method_ptr->get_volatiles().add(vcp);
		    $$ = vcp;
		}
	    ;

vclass_interface
	    :	inlet '?'
		{   $$ = $1; }
	    |	who_expression
		{   $$ = ((SNwho*)$1)->getWho();    }
	    ;

class_footer
	    :	Class_ender '.'
	    ;
%%

void yyerror(char *s)
{
    numberOfErrors++;
    cerr << currentFileName << ":";
    cerr << numberOfLines << ":";
    cerr << s << "\n";
    if (numberOfError > MaxNumberOfError) {
	cerr << currentFileName << ":" << numberOfLines << ":";
	cerr << "too many errors.\n";
	exit(1);
    }
}

static SNclass* outermostClass()
    /* ǳ¦饹ȤФ */
    /* PCSˤʤСclass_ptr ǳ¦饹 */
{
    SNtreeContext* outermost = SNtreeContextStack.last();
    if (outermost) return outermost->thisClass();
    else return class_ptr;
}

static bool validInletSlotname(SNname* slotname)
{
  SNclass* Class_ptr = outermostClass();
  if (!Class_ptr->get_islots().member(*slotname)) {
    /*	ƤʤåȤؤΥ
      Ĥä */
    if (Class_ptr->get_supers().length() != 0) {
      /*    ѾƤ륯饹	*/
      /*    ٹåФ	*/
      sprintf(ErrorMessageBuffer,
	      "warning: no declaration for "
	      "inlet slot '%s' in this class",
	      (char*)*slotname);
      yyerror(ErrorMessageBuffer);
      return TRUE; /* continue */
    }
    else {  /*	ʤХ顼åФ	*/
      sprintf(ErrorMessageBuffer,
	      "no declaration for "
	      "inlet slot '%s'", (char*)*slotname);
      yyerror(ErrorMessageBuffer);
      return FALSE;
    }
  }
  return TRUE;
}

static bool validOutletSlotname(SNname* slotname)
{
  SNclass* Class_ptr = outermostClass();
  if (!Class_ptr->get_oslots().member(*slotname)) {
    /*	ƤʤåȤؤΥ
      Ĥä */
    if (Class_ptr->get_supers().length() != 0) {
      /*    ѾƤ륯饹	*/
      /*    ٹåФ	*/
      sprintf(ErrorMessageBuffer,
	      "warning: No declaration for "
	      "outlet slot %s in this class.",
	      (char*)*slotname);
      yyerror(ErrorMessageBuffer);
      return TRUE; /* continue */
    }
    else {  /*	ʤХ顼åФ	*/
      sprintf(ErrorMessageBuffer,
	      "No declaration for "
	      "outlet slot '%s'", (char*)*slotname);
      yyerror(ErrorMessageBuffer);
      return FALSE;
    }
  }
  return TRUE;
}
