/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef inst2R2L_h
#define inst2R2L_h 1

#include "inst.h"
#include "LabelName.h"

class NameList;

class inst2R2L : public inst {
  Rind arg1;
  Rind arg2;
  LabelName label1;
  LabelName label2;

public:
  inst2R2L(Rind a1, Rind a2, char* l1, char* l2)
    : arg1(a1), arg2(a2), label1(l1), label2(l2) {}
  char* name() { return "inst2R2L"; }
  void print(ostream&);
};

#define inst2R2Ldeclare(nm)						      \
struct instClass(nm) : inst2R2L {					      \
  instClass(nm)(Rind a1, Rind a2, char* l1, char* l2) : (a1, a2, l1, l2) {}   \
  char* name() { return #nm; }						      \
}

#endif inst2R2L_h
