/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef inst_h
#define inst_h 1

#include <stream.h>
#include "gList.h"
#include "Rind.h"

// ̿ݥ饹

struct inst {
  char* copy(char*);
  void dispose(char*);
  virtual char* name() { return "inst"; }
  virtual void print(ostream& ost) { ost << form(" %s;", name()); };
  virtual void printWithIndent(ostream& ost) {
    ost << "\t";
    print(ost);
    ost << "\n";
  }
};

inline ostream& operator<< (ostream& ost, inst* ip)
{
  ip->print(ost);
  return ost;
}

// ̿

gListdeclare(inst);

struct instList : gList(inst) {
  void print(ostream&);
};

struct instListItr : gList_iterator(inst) {
};

#define instClass(name) name2(CD,name)

#endif inst_h
