/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef PIfgndef_h
#define PIfgndef_h 1

#include "cstring.h"
#include "inst.h"
#include "LabelName.h"

class PIfgndef : public inst {
  cstring linkage;
  LabelName label;
public:
  PIfgndef(char* t, char* l) : linkage(t), label(l) {}
  ~PIfgndef() {}
  char* name() { return ".foreign_definition"; }
  void print(ostream& ost) {
    ost << form(" %s ", name()) << linkage << ", " << (char*)label << ";";
  }
};

class PIname : public inst {
  cstring procName;
public:
  PIname(char* nm) : procName(nm) {}
  char* name() { return ".name"; }
  void print(ostream& ost) {
    ost << form(" %s ", name()) << procName << ";";
  }
};

class PIarg : public inst {
  char *fgnTypeName;
public:
  PIarg(char* nm) : fgnTypeName(copy(nm)) {}
  ~PIarg() {
    dispose(fgnTypeName);
  }
  char* name() { return ".arg"; }
  void print(ostream& ost) { ost << form(" %s %s;", name(), fgnTypeName); }
};

class PIreturn : public inst {
  char *fgnTypeName;
public:
  PIreturn(char* nm) : fgnTypeName(copy(nm)) {}
  ~PIreturn() {
    dispose(fgnTypeName);
  }
  char* name() { return ".return"; }
  void print(ostream& ost) { ost << form(" %s %s;", name(), fgnTypeName); }
};

class PIendfgn : public inst {
  LabelName label;
public:
  PIendfgn(char* l) : label(l) {}
  ~PIendfgn() {}
  char* name() { return ".end_foreign"; }
  void print(ostream& ost) {
    ost << form(" %s;\t%% %s", name(), (char*)label);
  }
};

#endif PIfgndef_h
