/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef CDset_inlet_h
#define CDset_inlet_h 1

#include "inst.h"

class CDset_inlet : public inst {
  Rind r;
  char* slotname;
public:
  CDset_inlet(Rind n, char* nm) : r(n), slotname(copy(nm)) {}
  ~CDset_inlet() {
    dispose(slotname);
  }
  char* name() { return "set_inlet"; }
  void print(ostream& ost)
    { ost << form(" %s R%d, %s;", name(), r, slotname); }
};

#endif CDset_inlet_h
