/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include "CDsend_self.h"
#include "CDclose.h"
#include "intList.h"
#include "RegTable.h"

void CDsend_self::print(ostream& ost)
{
  ost << form(" %s %s", name(), (char*)protocol);
  intListItr argRs(*argRinds);
  for (Rind r = argRs() ; r ; r = argRs.next()) {
    ost << form(", R%d", r - 1);
  }
  ost << ";";
}

void CDsend_self::autoClose(instList& code)
{
  intListItr argRs(*argRinds);
  for (Rind r = argRs() ; r ; r = argRs.next()) {
    regTable.decrement(r - 1);	// SNmessage::encodeArgs() Υ
    if (regTable.needClose(r - 1)) { // бƤ롣
      code.add(new CDclose(r - 1));
    }
  }
}
