/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/

%{
    /* $Id: aumc.lex,v 1.1 1991/06/14 13:36:13 konishi Exp konishi $ */


/*
 *  ߡʲ typedef  lex ץǤϻȤʤ
 *  yacc κ include ե˸롣
 */

typedef int SNname;
typedef int SNunit;

#include <math.h>

#include "y.tab.h"
#include "lex.h"

#define FALSE	0
#define TRUE	1

char* freshString();	    /* ʸΰ malloc ǳݤ롣 */
extern char ErrorMessageBuffer[];
void chopOffQuotation();
void convertEscSeq(char*);

    /* ʲΥХѿϡ				*/
    /* ɬפ˱ƴؿ initLex() ǽ롣	*/
int numberOfLines;	    /* Lex Կ */

%}

Digit			    [0-9]
Exp			    [Ee][-+]?{Digit}+
OrdChar			    [^\\]
SimpleEsc		    \\[nt\\\'\"]
OctDigit		    [0-7]
HexDigit		    [0-9a-fA-F]
OctEsc			    \\{OctDigit}{1,3}
HexEsc			    \\x{HexDigit}{1,2}
StrChar			    ([^\\\"]|{SimpleEsc}|{OctEsc}|{HexEsc})

%START ELEMENT_EXPECTED

%%

"'"([^"']|"\\'")*"'"	    {
				chopOffQuotation();
				yylval.asString = freshString(yytext);
				return(EscapedIdentifier);
			    }
\"{StrChar}*\"		    {
				yytext[yyleng - 1] = '\0';
				convertEscSeq((char*)yytext);
				yylval.asString = freshString(yytext + 1);
				return(String);
			    }
"&"{OrdChar}			{
				yylval.asInteger = yytext[1];
				return(Character);
			    }
"&"{SimpleEsc}			{
				switch (yytext[2]) {
				case 'n':
				    yylval.asInteger = '\n';
				    break;
				case 't':
				    yylval.asInteger = '\t';
				    break;
				case '\\':
				    yylval.asInteger = '\\';
				    break;
				case '\'':
				    yylval.asInteger = '\'';
				    break;
				case '\"':
				    yylval.asInteger = '\"';
				    break;
				}
				return(Character);
			    }
"&"{OctEsc}		    {
				sscanf(yytext + 2, "%3o", &(yylval.asInteger));
				return(Character);
			    }
"&"{HexEsc}		    {
				sscanf(yytext + 3, "%x", &(yylval.asInteger));
				return(Character);
			    }
class			    return(Class_beginner);
end			    return(Class_ender);
super			    return(Super_class_declarer);
in			    return(Inlet_slot_declarer);
out			    return(Outlet_slot_declarer);
foreign_call		    return(Foreign_call_declarer);
call			    return(Foreign_proc_declarer);
arg			    return(Foreign_arg_declarer);
result			    return(Foreign_result_declarer);
return			    return(Foreign_retval_declarer);
"->"			    return(Descending_neck);
"-|"			    return(Terminating_neck);
"::"			    return(Closed_interface);
"=="			    return(Equal);
"!="			    return(Nequal);
">="			    return(GE);
"=<"			    return(LE);
">>"			    return(Right_shift);
"<<"			    return(Left_shift);
"##"			    return(Class_object_mark);
"#@"			    return(Create_locally);
"car"			    return(Car);
"cdr"			    return(Cdr);
"and"			    return(And);
"or"			    return(Or);
"xor"			    return(Xor);
"not"			    return(Not);
"classof"		    return(Classof);
"issimple"		    return(IsSimple);
"isbuiltin"		    return(IsBuiltin);
"`true"			    {
				yylval.asInteger = TRUE;
				return(Boolean);
			    }
"`false"		    {
				yylval.asInteger = FALSE;
				return(Boolean);
			    }
"mod"			    return(Mod);
"$self"			    return(Self);
"$sink"			    return(Sink);
[ \t]+			    ;
\n			    numberOfLines++;
\%.*$			    ;
("0f"){Digit}+"."{Digit}*({Exp})?   |
("0f"){Digit}*"."{Digit}+({Exp})?   |
("0f"){Digit}+{Exp}		{
				yylval.asDouble = atof(yytext + 2);
				if (yylval.asDouble > HUGE) {
				sprintf(ErrorMessageBuffer,
					"0f%g is out of float range",
					yytext),
				yyerror(ErrorMessageBuffer);
				}
				return(Float);
			    }
("0d")?{Digit}+"."{Digit}*({Exp})?  |
("0d")?{Digit}*"."{Digit}+({Exp})?  |
("0d")?{Digit}+{Exp}		    {
				yylval.asDouble
				    = atof(yytext[1] == 'd' ? yytext + 2
							    : yytext);
				return(Double);
			    }
"_"/[^A-Za-z0-9_]	    return('_');
[A-Z_][A-Za-z0-9_]*	    {
				yylval.asString = freshString(yytext);
				return(Capital);
			    }
[a-z][A-Za-z0-9_]*	    {
				yylval.asString = freshString(yytext);
				return(Identifier);
			    }
[0-9]*		    {
				yylval.asInteger = atol(yytext);
				return(Integer);
			    }
"."			    return('.');
","			    return(',');
"["			    return('[');
"]"			    return(']');
"{"			    return('{');
"}"			    return('}');
"\\"			    return('\\');
"("			    return('(');
")"			    return(')');
"+"			    return('+');
"-"			    return('-');
"/"			    return('/');
"*"			    return('*');
"$"			    return('$');
"="			    return('=');
"#"			    return('#');
"@"			    return('@');
"!"			    return('!');
"?"			    return('?');
"^"			    return('^');
":"			    return(':');
"|"			    return('|');
";"			    return(';');
"'"			    return('\'');
"`"			    return('`');
"<"			    return('<');
">"			    return('>');
"~"			    return('~');

%%

#include <ctype.h>
#include <strings.h>
#include <errno.h>

char* freshString(source)
char* source;
{
    char* newString = (char*)malloc(strlen(source) + 1);
    if (newString == 0) {
	perror("In function freshString()");
	exit(1);
    }
    return strcpy(newString, source);
}

void disposeString(target)
char* target;
{
    free(target);
}

void initLex()
{
    numberOfLines = 1;		/* եĤȤ˽ɬפ */
}

void chopOffQuotation()
{
    unsigned char *p = yytext;
    unsigned char *s = yytext + 1;
    yytext[yyleng - 1] = '\0';
    while (*s) {
	if (*s == '\\') {
	    s++;
	    if (*s == '\0') break;
	}
	*p++ = *s++;
    }
    *p = '\0';
}

void convertEscSeq(char* rawstring)
{
    long digitvalue = 0;
    int ndigits;
    char* p = rawstring + 1;
    char* q = p;
    while (*q != '\0') {
	if (*q != '\\') { *p++ = *q++; continue; }
	q++;
	switch (*q) {
	case 'n':   *p = '\n'; q++; break;
	case 't':   *p = '\t'; q++; break;
	case '\\':  *p = '\\'; q++; break;
	case '\'':  *p = '\''; q++; break;
	case '\"':  *p = '\"'; q++; break;
	case 'x':
	    sscanf(++q, "%2x", &digitvalue);
	    *p = digitvalue;
	    ndigits = 0;
	    while (isxdigit(*q)) {
		ndigits++;
		if (ndigits > 2) break;
		q++;
	    }
	    break;
	case '0':   case '1':	case '2':   case '3':
	case '4':   case '5':	case '6':   case '7':
	    sscanf(q, "%3o", &digitvalue);
	    *p = digitvalue;
	    ndigits = 0;
	    while (isdigit(*q)) {
		if (*q == '9' || *q == '8') break;
		ndigits++;
		if (ndigits > 3) break;
		q++;
	    }
	    break;
	default:
	    *p = *q++;
	    break;
	}
	p++;
    }
    *p = '\0';
}
