/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include <stream.h>
#include <errno.h>
#include <stdlib.h>
#ifdef IOSTREAM_2_0
#include <unistd.h>
#endif
#include <signal.h>
#include "SNunit.h"
#include "SNclass.h"
#include "SNtree.h"
#include "SCtree.h"
#include "SCclass.h"
#include "SCvar.h"
#include "Classref.h"
#include "Protocol.h"
#include "inst.h"
#include "y.tab.h"
#include "version.h"
#include "makedate.h"
#include "SNerror.h"
#include "parse.h"
#include "aumc.h"

// public:
int numberOfParseErrors;	// $B9=J82r@OCf$N%(%i!<$N8D?t(J

// private:
int flagForceCompilation;	// $B9=J82r@OCf$K%(%i!<$,$"$C$F$b(J
				// $B0J9_$N%U%'!<%:$r<B9T$9$k$+$I$&$+!#(J
int flagPrintSyntaxTree;	// $B9=J8LZ$rI=<($9$k$+$I$&$+!#(J
int flagPrintScopeTree;		// $B%9%3!<%WLZ$rI=<($9$k$+$I$&$+!#(J
int flagPrintReferenceCount;	// $B3FJQ?t$N;2>H?t$rI=<($9$k$+$I$&$+!#(J
int flagPrintProtocols;		//
int flagPrintSelectorLength;	//
int flagDontEncode;		// $B%3!<%I$N@8@.$r$7$J$$$+$I$&$+!#(J
char* asmFilename = 0;		// $BCj>]%3!<%I%U%!%$%kL>(J
char* const asmFileExtention = ".aao"; // $BCj>]%3!<%I%U%!%$%k$N3HD%;R(J

extern "C" {
#include "lex.h"
}

extern char* sys_errorlist[];

void usage()
{
  cerr << "usage: aumc [-dncrpsqvCP] [- o ofile] [file]\n";
  cerr << "\td\tdebug\n";
  cerr << "\tn\tprint syntax tree\n";
  cerr << "\tc\tprint scope tree\n";
  cerr << "\tr\tprint reference count\n";
  cerr << "\tp\tprint protocols\n";
  cerr << "\ts\tprint selector length\n";
  cerr << "\tq\tdon't generate code\n";
  cerr << "\tv\tprint version then exit\n";
  cerr << "\to\tspecify output file name\n";
  cerr << "\tC\tclassref table size(default 128)\n";
  cerr << "\tP\tprotocol table size(default 1024)\n";
}

static void printversion()
{
  cout << version << " " << makedate << "\n";
}

void abortQuietly(...)
{
  cerr << "sorry, a system error is hit.\n";
  _exit(1);
}

void setSignalHandlers()
{
  signal(SIGILL, abortQuietly);	 // illegal instruction
  signal(SIGTRAP, abortQuietly); // trace trap
  signal(SIGIOT, abortQuietly);	 // IOT instruction
  signal(SIGEMT, abortQuietly);	 // EMT instruction
  signal(SIGFPE, abortQuietly);	 // floating point exception
  signal(SIGBUS, abortQuietly);	 // bus error
  signal(SIGSEGV, abortQuietly); // segmentation violation
  signal(SIGSYS, abortQuietly);	 // segmentation violation
}

void resetSignalHandlers()
{
  signal(SIGILL, SignalDefault);  // illegal instruction
  signal(SIGTRAP, SignalDefault); // trace trap
  signal(SIGIOT, SignalDefault);  // IOT    instruction
  signal(SIGEMT, SignalDefault);  // EMT    instruction
  signal(SIGFPE, SignalDefault);  // floating point exception
  signal(SIGBUS, SignalDefault);  // bus    error
  signal(SIGSEGV, SignalDefault); // segmentation violation
  signal(SIGSYS, SignalDefault);  // segmentation violation
}


static void openCodeFile(const char* const srcfile)
     // $B%=!<%9%U%!%$%kL>$+$i%3!<%I%U%!%$%kL>$r7h$a!"(J
     // $B$=$NL>A0$N%U%!%$%k$r%*!<%W%s$9$k!#(J
{
  char* extent = rindex(srcfile, '.');
  int len = extent ? extent - srcfile : strlen(srcfile);
  int asmlen = len + strlen(asmFileExtention) + 1;
  if (asmFilename == 0) {
    asmFilename = new char[asmlen];
    strcpy(asmFilename, srcfile);
    strcpy(asmFilename + len, asmFileExtention);
  }
  if (freopen(asmFilename, "w", stdout) == 0) {
    cerr << "aumc : can't open output file " << asmFilename << ".\n";
    exit(1);
  }
#if __GNUG__ == 2
  delete[] asmFilename;
#else
  delete[asmlen] asmFilename;
#endif
}

main(int argc, char** argv)
{
  int c;
  extern char *optarg;
  extern int optind;
  int errflg = 0;

  setSignalHandlers();

  while ((c = getopt(argc, argv, "dfncrpsqvo:C:P:")) != -1)
    switch (c) {
    case 'd':
      yydebug = 1;  /* turn on the bison's debugger */
      break;
    case 'n':
      flagPrintSyntaxTree++;
      break;
    case 'c':
      flagPrintScopeTree++;
      break;
    case 'r':
      flagPrintReferenceCount++;
      break;
    case 'p':
      flagPrintProtocols++;
      break;
    case 's':
      flagPrintSelectorLength++;
      break;
    case 'q':
      flagDontEncode++;
      break;
    case 'v':
      printversion();
      exit(0);
    case 'o':
      asmFilename = new char[strlen(optarg) + 1];
      strcpy(asmFilename, optarg);
      break;
    case 'C':
      classrefTableSize = atoi(optarg);
      break;
    case 'P':
      protocolTableSize = atoi(optarg);
      break;
    case '?':
      errflg++;
    }
  if (errflg) {
    usage();
    exit (2);
  }
  if (optind >= argc) {
    currentFileName = "*stdin*";
  }
  else if (argc - optind > 1) {
    usage();
    exit(2);
  }
  else {
    if (freopen(argv[optind], "r", stdin) == 0) {
      cerr << "aumc : can't open " << argv[optind] << "\n";
      exit(1);
    }
    currentFileName = argv[optind];
    if (!flagDontEncode) openCodeFile(currentFileName);
  }

  initLex();

  protocolTable = new ProtocolTable(protocolTableSize);
  classrefTable = new ClassrefTable(classrefTableSize);

  if (yyparse()) {
    exit(1);
  }
  currentFileName = unsetFileName;
}

void compile()
{
  // $B9=J82r@O7k2L$N=PNO(J
  if (flagPrintSyntaxTree)
    class_ptr->print(cout);

  // $B%\%i%?%$%k$KL>A0$r$D$1$k!#(J
  SNtree syntaxTree(class_ptr);
  syntaxTree.nameVolatiles();

  // $B%9%3!<%W2r@O(J
  SCclass* scopeTree = new SCclass(class_ptr); // $B%9%3!<%WLZ$r:n$k(J
  markRootandLeaf(scopeTree);
  markAncestorofInlet(scopeTree);
  SCvarList targets;
  markSinks(scopeTree, targets);
  if (numberOfError > 0) return;
  if (flagPrintScopeTree)	// $B%9%3!<%W2r@O$N7k2L$r=PNO$9$k!#(J
    scopeTree->print(0);
  mapImportList(scopeTree);

  class_ptr->markUnusedVars();
  if (numberOfError > 0) return;

  // $B;2>H?t2r@O(J
  class_ptr->split();

  syntaxTree.bindInletAndTopOutlet();
  if (flagPrintReferenceCount)	// $B;2>H?t2r@O$N7k2L$r=PNO$9$k(J
    class_ptr->print_rc();

  // $B%\%i%?%$%k%/%i%92r@O(J
  syntaxTree.checkSelectorLengths();	// $B0z?tIU$-$N%a%=%C%I$r;}$D(J
				    // $B%\%i%?%$%k%/%i%9Dj5A$r8!=P$9$k!#(J
  if (numberOfError > 0) return;

  if (flagPrintProtocols)	// $BDj5A$5$l$F$$$k%a%=%C%IL>$r=PNO$9$k(J
    syntaxTree.printProtocols();
  if (flagPrintSelectorLength)	// $B%\%i%?%$%k%/%i%92r@O$N7k2L$r=PNO$9$k(J
    syntaxTree.printSelectorLengths();

  // $B%3!<%I@8@.(J
  if (!flagDontEncode) {
    syntaxTree.encodeAndPrint(cout);
    syntaxTree.printSyncCode(cout);
  }
}
