#!/bin/sh
# Makefile.sh: a shell script to make Makefiles in subdirectories.
# Location: $(TOP)/aumc
# Executed-By: $(TOP)/Configure

config_sh="../config.sh"
Makefile="Makefile"
Makefile_in="Makefile.in"
subdirs=". struct register code syntax scope"
config_defs="config.defs"

if test ! -f $config_sh ; then
	echo "Can't find $config_sh"; exit 1
fi
. $config_sh

cat <<EOT >$config_defs
# parser generator
YACC			=${yacc}

# g++ path
PLUSPLUS		=g++

# options for g++
OPTION			=${options}

# top directory of source files
TOP				=${top}

# a script for 'make depend'
MAKEDEPEND		=csh -f ${top}/pas/etc/makedepend

# a script to make directories
MKDIRP			=sh ${top}/pas/etc/mkdir-p

# directory where aumc is installed
INSTALLBINDIR	=${bindir}

# Macro definition to tell g++ that new iostream library is available
STREAMLIB		=${d_iostream}

EOT

for d in ${subdirs}; do
    mf="${d}/${Makefile}"
    mi="${d}/${Makefile_in}"
    echo 'making '${mf}' from "'${config_defs}'" and "'${mi}'"'
    if [ -w ${mf} ]; then
	  rm -f ${mf}
    fi
	if test ${d} = "."; then
		boss="\$(TOP)/Makefile"
	else
		boss="\$(TOP)/aumc/Makefile"
	fi
    cat - ${config_defs} ${mi} > ${mf} << END_OF_INPUT
# Makefile: a makefile 
# Location: \$(TOP)/aumc/${d}
# Executed-By: ${boss}

END_OF_INPUT
done

rm -f ${config_defs}
