/**************************************************************************
   File:  malloc4.c

   2,3,4 dimensional memory allocators.
   written by Xavier Bouyssounouse
***************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include "malloc4.h"

#define STOP_FLAG 1

#ifdef ANSI_FUNC

unsigned char *malloc1(
  unsigned int size
  )
#else

unsigned char *malloc1(size)
unsigned int size;
#endif
{
    char *ptr;

    if ((int)(ptr= malloc(size))% sizeof(double))
    	fprintf(stderr,"Warning: malloc returned pointer on invalid boundary.\n");
    return (unsigned char *) ptr;
}

#ifdef ANSI_FUNC

void free2(
  unsigned char **temp2
  )
#else

void free2(temp2)	
unsigned char **temp2;
#endif
/*****************************************************/
/* Frees 2D memory allocated by malloc2 or malloc2c. */	
/*****************************************************/
{			
    int i=0;

    while (temp2[i])
	free((char *) temp2[i++]);
    free((char *) temp2);
}


#ifdef ANSI_FUNC

unsigned char **malloc2(
  int n2,
  int n1
  )
#else

unsigned char **malloc2(n2,n1)
int n2,n1;
#endif
/********************************/
/* Dynamic 2D memory allocator. */
/********************************/
{
    unsigned char **temp2;
    int i;
  
    if (!(temp2 = (unsigned char **) malloc1((n2+1)*sizeof(*temp2)+sizeof(int))))
	return NULL;
    temp2[n2] = NULL;
    for (i=0; i<n2; i++)
	if (!(temp2[i] = (unsigned char *) malloc1(n1))) {
	    free2(temp2);
	    if (STOP_FLAG) 
		perror("Out of memory");
	    return (NULL);
	}
    memcpy((char *) (temp2+n2+1),(char *) (&n1),sizeof(int));
    return (temp2);
}


#ifdef ANSI_FUNC

unsigned char **malloc2c(
  int n2,
  int n1
  )
#else

unsigned char **malloc2c(n2,n1)
int n2,n1;
#endif
/*******************************************/
/* Dynamic 2D contiguous memory allocator. */
/*******************************************/
{
    unsigned char **temp2,*p;
    int i;
  
    if (!(temp2 = (unsigned char **) malloc1((n2+1)*sizeof(*temp2)+sizeof(int))))
	return NULL;
    if (!(p=(unsigned char *) malloc1(n2*n1))) {
	free((char *) temp2);
	if (STOP_FLAG) 
	    perror("Out of memory");
	return (NULL);
    }
    temp2[n2] = NULL;
    for (i=0; i<n2; i++)
	temp2[i] = p+n1*i;
    memcpy((char *) (temp2+n2+1),(char *) &n1,sizeof(int));
    return (temp2);
}


#ifdef ANSI_FUNC

void free3(
  unsigned char ***temp3
  )
#else

void free3(temp3)	
unsigned char ***temp3;
#endif
/*****************************************/
/* Frees 3D memory allocated by malloc3. */	
/*****************************************/
{			
    int i=0;

    while (temp3[i])
	free2(temp3[i++]);
    free((char *) temp3);
}


#ifdef ANSI_FUNC

unsigned char ***malloc3(
  int n3,
  int n2,
  int n1
  )
#else

unsigned char ***malloc3(n3,n2,n1)
int n3,n2,n1;
#endif
/********************************/
/* Dynamic 3D memory allocator. */
/********************************/
{
    unsigned char ***temp3;
    int i;
  
    if (!(temp3 = (unsigned char ***) malloc1((n3+1)*sizeof(**temp3))))
	return NULL;
    temp3[n3] = NULL;
    for (i=0; i<n3; i++)
	if (!(temp3[i] = malloc2(n2,n1))) {
	    free3(temp3);
	    return (NULL);
	}
    return (temp3);
}


#ifdef ANSI_FUNC

unsigned char ***malloc3c(
  int n3,
  int n2,
  int n1
  )
#else

unsigned char ***malloc3c(n3,n2,n1)
int n3,n2,n1;
#endif
/************************************************/
/* Dynamic 3D semi-contiguous memory allocator. */
/************************************************/
{
    unsigned char ***temp3;
    int i;
  
    if (!(temp3 = (unsigned char ***) malloc1((n3+1)*sizeof(**temp3))))
	return NULL;
    temp3[n3] = NULL;
    for (i=0; i<n3; i++)
	if (!(temp3[i] = malloc2c(n2,n1))) {
	    free3(temp3);
	    return (NULL);
	}
    return (temp3);
}


#ifdef ANSI_FUNC

void free4(
  unsigned char ****temp4
  )
#else

void free4(temp4)	
unsigned char ****temp4;
#endif
/*****************************************/
/* Frees 4D memory allocated by malloc4. */	
/*****************************************/
{			
    int i=0;

    while (temp4[i])
	free3(temp4[i++]);
    free((char *) temp4);
}


#ifdef ANSI_FUNC

unsigned char ****malloc4c(
  int n4,
  int n3,
  int n2,
  int n1
  )
#else

unsigned char ****malloc4c(n4,n3,n2,n1)
int n4,n3,n2,n1;
#endif
/************************************************/
/* Dynamic 4D semi-contiguous memory allocator. */
/************************************************/
{
    unsigned char ****temp4;
    int i;
  
    if (!(temp4 = (unsigned char ****) malloc1((n4+1)*sizeof(***temp4))))
	return NULL;
    temp4[n4] = NULL;
    for (i=0; i<n4; i++)
	if (!(temp4[i] = malloc3c(n3,n2,n1))) {
	    free4(temp4);
	    return (NULL);
	}
    return (temp4);
}

#ifdef ANSI_FUNC

unsigned char ****malloc4(
  int n4,
  int n3,
  int n2,
  int n1
  )
#else

unsigned char ****malloc4(n4,n3,n2,n1)
int n4,n3,n2,n1;
#endif
/************************************************/
/* Dynamic 4D semi-contiguous memory allocator. */
/************************************************/
{
    unsigned char ****temp4;
    int i;
  
    if (!(temp4 = (unsigned char ****) malloc1((n4+1)*sizeof(***temp4))))
	return NULL;
    temp4[n4] = NULL;
    for (i=0; i<n4; i++)
	if (!(temp4[i] = malloc3(n3,n2,n1))) {
	    free4(temp4);
	    return (NULL);
	}
    return (temp4);
}

#ifdef ANSI_FUNC

void getsize2(
  unsigned char **buf,
  int *y_siz,
  int *x_siz
  )
#else

void getsize2(buf,y_siz,x_siz)
unsigned char **buf;
int *y_siz,*x_siz;
#endif
/*************************************************************
    Get size of 2d array allocated by malloc2() or malloc2c().
**************************************************************/
{
    for (*y_siz=0; buf[*y_siz]; (*y_siz)++);
    memcpy((char *) x_siz,(char *) (buf+*y_siz+1),sizeof(int));
}

#ifdef ANSI_FUNC

void getsize3(
  unsigned char ***buf,
  int *z_siz,
  int *y_siz,
  int *x_siz
  )
#else

void getsize3(buf,z_siz,y_siz,x_siz)
unsigned char ***buf;
int *z_siz,*y_siz,*x_siz;
#endif
/*************************************************************
    Get size of 3d array allocated by malloc3() or malloc3c().
**************************************************************/
{
    for (*z_siz=0; buf[*z_siz]; (*z_siz)++);
    for (*y_siz=0; buf[0][*y_siz]; (*y_siz)++);
    memcpy((char *) x_siz,(char *) (buf[0]+*y_siz+1),sizeof(int));
}

#ifdef ANSI_FUNC

void getsize4(
  unsigned char ****buf,
  int *z_siz,
  int *y_siz,
  int *x_siz,
  int *w_siz
  )
#else

void getsize4(buf,z_siz,y_siz,x_siz,w_siz)
unsigned char ****buf;
int *z_siz,*y_siz,*x_siz,*w_siz;
#endif
/*************************************************************
    Get size of 4d array allocated by malloc4() or malloc4c().
**************************************************************/
{
    for (*z_siz=0; buf[*z_siz]; (*z_siz)++);
    for (*y_siz=0; buf[0][*y_siz]; (*y_siz)++);
    for (*x_siz=0; buf[0][0][*x_siz]; (*x_siz)++);
    memcpy((char *) w_siz,(char *) (buf[0][0]+*x_siz+1),sizeof(int));
}
