/*
SGPC: Simple Genetic Programming in C
(c) 1993 by Walter Alden Tackett and Aviram Carmi
 
 This code and documentation is copyrighted and is not in the public domain.
 All rights reserved. 
 
 - This notice may not be removed or altered.
 
 - You may not try to make money by distributing the package or by using the
   process that the code creates.
 
 - You may not distribute modified versions without clearly documenting your
   changes and notifying the principal author.
 
 - The origin of this software must not be misrepresented, either by
   explicit claim or by omission.  Since few users ever read sources,
   credits must appear in the documentation.
 
 - Altered versions must be plainly marked as such, and must not be
   misrepresented as being the original software.  Since few users ever read
   sources, credits must appear in the documentation.
 
 - The authors are not responsible for the consequences of use of this 
   software, no matter how awful, even if they arise from flaws in it.
 
If you make changes to the code, or have suggestions for changes,
let us know!  (gpc@ipld01.hac.com)
*/

#ifndef _GPC_H_
#define _GPC_H_

#ifndef lint
static char gpc_h_rcsid[]="$Id: gpc.h,v 2.13 1993/05/29 22:59:21 gpc-avc Exp gpc-avc $";
#endif

/*
 *
 * $Log: gpc.h,v $
 * Revision 2.13  1993/05/29  22:59:21  gpc-avc
 * use M_PI from math.h instead of defining here.
 *
 * Revision 2.12  1993/04/22  07:39:12  gpc-avc
 * Removed old log messages
 *
 * Revision 2.11  1993/04/14  05:01:02  gpc-avc
 * added format and ckpt_format to pop_struct
 *
 *
 */

#if __STDC__ || defined(__cplusplus)
#define P_(s) s
#define ANSI_FUNC
#else
#define P_(s) ()
#ifdef ANSI_FUNC
#undef ANSI_FUNC
#endif
#endif

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

/* #define PI 3.14159265358979323846  in math.h */

#ifdef _MAIN_
#define EXTERN
#else
#define EXTERN extern
#endif

#define VOID void

/* user-defined constants configure simulation */
/* generic var/ptr/function type */
#define GENERIC TYPE

#define ALLOW_CONST 1
#define INDENT 2

/* system symbolic names */
#define FUNCTION 0
#define TERMINAL 1

#define FULL   2
#define GROW   3
#define RAMPED 4

#define TOURNAMENT 5
#define OVERSELECT 6
#define FITNESSPROP 7

#define max(x,y) ((x)>(y)?(x):(y))

#define	function_arity(t) pop[(t)->pop].function_table[(t)->id].arity
#define	function_is_macro(t) pop[(t)->pop].function_table[(t)->id].macro
#define	function_printname(t) pop[(t)->pop].function_table[(t)->id].printname
#define	function_code(t) pop[(t)->pop].function_table[(t)->id].code

#define terminal_val(t) pop[(t)->pop].terminal_table[(t)->id].val
#define	terminal_printname(t) pop[(t)->pop].terminal_table[(t)->id].printname
#define terminal_constant_generator(t) \
  pop[(t)->pop].terminal_table[(t)->id].constant_generator
#define terminal_is_constant(t) ((t)->id == pop[(t)->pop].terminal_table_size)

typedef struct tnode {
  int		nodetype;
  int		id;
  int		pop;
  union {
    struct fdata	*func;
    struct tdata	*term;
  } type;
} tree;

typedef struct fdata {
  tree		**arg;
  GENERIC	*argvals;
} function;
  
typedef struct fte {
  int		arity;
  int		macro;
  int		enabled;
  char		*printname;
  GENERIC	(*code) P_(( ));
} function_table_entry;

typedef struct tdata {
  GENERIC	*valptr;
} terminal;

typedef struct tte {
  GENERIC	val;
  char		*printname;
  GENERIC	(*constant_generator) P_(( ));
} terminal_table_entry;

typedef struct popstruct {
  int			population_size;
  int			steady_state;
  int			my_row, my_col;
  char			*load_from_file;
  char			*format;
  char			*ckpt_format;
  int			max_depth_for_new_trees;
  int			max_depth_after_crossover;
  int			max_mutant_depth;
  int			grow_method;
  int			selection_method;
  int			tournament_K;
  int			*tournament_index;
  float			deme_search_radius_sigma;
  float			crossover_func_pt_fraction;
  float			crossover_any_pt_fraction;
  float			fitness_prop_repro_fraction;
  float			parsimony_factor;
  float			*standardized_fitness;
  float			*adjusted_fitness;
  float			*normalized_fitness;
  int			*fitness_sort_index;
  tree			**population;
  tree			**new_population;
  tree			*best_of_generation;
  tree			*best_of_run;
  int			best_of_run_gen;
  float			best_of_gen_fitness;
  float			best_of_run_fitness;
  function_table_entry 	*function_table; /* terminal_table has an extra entry:
					    terminal_table[terminal_table_size]
					    is the printf format string for use
					    with reading/printing of constants
					    */
  terminal_table_entry	*terminal_table;
  int			function_table_size;
  int			terminal_table_size;
} pop_struct;


/* GLOBALS */
EXTERN pop_struct	*POP;
EXTERN int		NUMPOPS;
EXTERN int		NUMGENS;
EXTERN int		X_FLAG;
EXTERN int		DEMES;
EXTERN int		DEMEROWS;
EXTERN int		DEMECOLS;
EXTERN pop_struct	***GRID;
EXTERN int		CHECKPOINT_FREQUENCY;
EXTERN int		START_GEN;
EXTERN FILE		*CKPT_FILE;

#include "proto.h"

#endif
