/*
SGPC: Simple Genetic Programming in C
(c) 1993 by Walter Alden Tackett and Aviram Carmi
 
 This code and documentation is copyrighted and is not in the public domain.
 All rights reserved. 
 
 - This notice may not be removed or altered.
 
 - You may not try to make money by distributing the package or by using the
   process that the code creates.
 
 - You may not distribute modified versions without clearly documenting your
   changes and notifying the principal author.
 
 - The origin of this software must not be misrepresented, either by
   explicit claim or by omission.  Since few users ever read sources,
   credits must appear in the documentation.
 
 - Altered versions must be plainly marked as such, and must not be
   misrepresented as being the original software.  Since few users ever read
   sources, credits must appear in the documentation.
 
 - The authors are not responsible for the consequences of use of this 
   software, no matter how awful, even if they arise from flaws in it.
 
If you make changes to the code, or have suggestions for changes,
let us know!  (gpc@ipld01.hac.com)
*/

#ifndef lint
static char fitness_c_rcsid[]="$Id: fitness.c,v 1.8 1993/04/30 05:10:02 gpc-avc Exp gpc-avc $";
#endif

/*
 *
 * $Log: fitness.c,v $
 * Revision 1.8  1993/04/30  05:10:02  gpc-avc
 * Restructured directories and Makefile
 *
 * Revision 1.6  1993/04/09  22:57:22  gpc-avc
 * created regression_fitness() that returns the value of
 * the function we want to evolve
 *
 *
 */

#include <stdio.h>
#include <malloc.h>
#include <errno.h>
#include "gpc.h"


GENERIC **fitness_cases_table;
GENERIC **test_cases_table;
GENERIC **fitness_cases_table_out;
GENERIC **test_cases_table_out;
int numfc;
int numtc;

#define xabs(x) ((x)>0?(x):(-(x)))


GENERIC regression_function P_((
  GENERIC x
  ));

#include <math.h>
#ifdef ANSI_FUNC

GENERIC regression_function(
  GENERIC x
  )
#else

GENERIC regression_function(x)
  GENERIC x;
#endif
{
  return (GENERIC)sin((double)x);
}


#ifdef ANSI_FUNC

VOID define_fitness_cases(
  int 		numpops,
  int 		numgens,
  pop_struct	*pop
     )
#else

VOID define_fitness_cases(numpops,numgens,pop)
  int 		numpops;
  int 		numgens;
  pop_struct	*pop;
#endif
{
  /* this template makes all of the fitness cases the same for all
     populations, but that isn't necessary */

  int	p,i;
  float range;

  numfc = 201;    /* number of fitness or training cases */
  numtc = 201;    /* number of test or validation cases */
  range = 2.0*M_PI; /* centered about zero */

  fitness_cases_table = (float **) malloc(numpops*sizeof(float *)); 
  test_cases_table = (float **) malloc(numpops*sizeof(float *)); 
  fitness_cases_table_out = (float **) malloc(numpops*sizeof(float *)); 
  test_cases_table_out = (float **) malloc(numpops*sizeof(float *)); 
  for (p=0; p<numpops; p++) {
    fitness_cases_table[p] = (float *) malloc(numfc * sizeof(float));
    test_cases_table[p] = (float *) malloc(numtc * sizeof(float));
    fitness_cases_table_out[p] = (float *) malloc(numfc * sizeof(float));
    test_cases_table_out[p] = (float *) malloc(numtc * sizeof(float));
    for (i=0; i<numfc; i++) {
      /*    evenly spaced 'range' about zero: */
      fitness_cases_table[p][i] = (2.0*range*(float)i/(float)numfc)-range; 

      /*    evenly spaced zero..'range':
      fitness_cases_table[p][i] = range * (float)i / (float)numfc;
      */

      fitness_cases_table_out[p][i] = 
	regression_function(fitness_cases_table[p][i]);
    }
    for (i=0; i<numtc; i++) {
      /* validation test cases same as the training set */
      test_cases_table[p][i] = fitness_cases_table[p][i];

      /* validation could be random within the range:
      test_cases_table[p][i] = random_float(range);
      or range centered about zero:
      test_cases_table[p][i] = random_float(2.0*range)-range;
      */

      test_cases_table_out[p][i] = regression_function(test_cases_table[p][i]);
    }
  }
}

#ifdef ANSI_FUNC

VOID evaluate_fitness_of_populations(
     int 	numpops,
     int 	numgens,
     pop_struct	*pop,
     int	p
     )
#else

VOID evaluate_fitness_of_populations(numpops,numgens,pop,p)
     int 	numpops;
     int 	numgens;
     pop_struct	*pop;
     int	p;
#endif
{
  int		i;

  for (i=0; i<pop[p].population_size; i++) {
    pop[p].standardized_fitness[i] =
      evaluate_fitness_of_individual(pop,p,pop[p].population[i],i);
  }
}

#ifdef ANSI_FUNC

float evaluate_fitness_of_individual(
     pop_struct	*pop,
     int	p,
     tree	*t,
     int	i
     )
#else

float evaluate_fitness_of_individual(pop, p, t, i)
     pop_struct	*pop;
     int	p;
     tree	*t;
     int	i;
#endif
{
  int		j;
  float		sum = 0.0;

  for (j=0; j<numfc; j++) {
    load_terminal_set_values(pop,p,&(fitness_cases_table[p][j]));
    sum += xabs(fitness_cases_table_out[p][j]-eval(t));
  }
  return sum;
}

#ifdef ANSI_FUNC

float validate_fitness_of_tree(
     int	numpops,
     int	numgens,
     pop_struct *pop,
     int	p,
     tree 	*t
     )
#else

float validate_fitness_of_tree(numpops, numgens, pop, p, t)
  int		numpops;
  int		numgens;
  pop_struct	*pop;
  int		p;
  tree		*t;
#endif
{
  int	        j;
  float 	fitness=0.0;

  fitness = 0.0;
  for (j=0; j<numtc; j++) {
    load_terminal_set_values(pop,p,&(test_cases_table[p][j]));
    fitness += xabs(test_cases_table_out[p][j] -  eval(t));
  }

  return fitness;
}
  
#ifdef ANSI_FUNC

int terminate_early(
  int 		numpops,
  int 		numgens,
  pop_struct 	*pop
  )
#else

int terminate_early(numpops,numgens,pop)
  int		numpops;
  int		numgens;
  pop_struct 	*pop;
#endif
{
  int	p,i;

  for (p=0; p<numpops; p++) {
    for (i=0; i<pop[p].population_size; i++) {
      if (pop[p].standardized_fitness[i] <= 0.0) {
	return 1;
      }
    }
  }
  return 0;
}


