/* THE "DONUT PROBLEM" */
/*
SGPC: Simple Genetic Programming in C
(c) 1993 by Walter Alden Tackett and Aviram Carmi
 
 This code and documentation is copyrighted and is not in the public domain.
 All rights reserved. 
 
 - This notice may not be removed or altered.
 
 - You may not try to make money by distributing the package or by using the
   process that the code creates.
 
 - You may not distribute modified versions without clearly documenting your
   changes and notifying the principal author.
 
 - The origin of this software must not be misrepresented, either by
   explicit claim or by omission.  Since few users ever read sources,
   credits must appear in the documentation.
 
 - Altered versions must be plainly marked as such, and must not be
   misrepresented as being the original software.  Since few users ever read
   sources, credits must appear in the documentation.
 
 - The authors are not responsible for the consequences of use of this 
   software, no matter how awful, even if they arise from flaws in it.
 
If you make changes to the code, or have suggestions for changes,
let us know!  (gpc@ipld01.hac.com)
*/

#ifndef lint
static char fitness_c_rcsid[]="$Id: fitness.c,v 1.3 1993/07/07 05:40:16 gpc-avc Exp gpc-avc $";
#endif

/*
 *
 * $Log: fitness.c,v $
 * Revision 1.3  1993/07/07  05:40:16  gpc-avc
 * Modified code for terminate_early()
 *
 * Revision 1.2  1993/05/14  03:34:12  gpc-avc
 * fixed minor problems
 *
 * Revision 1.1  1993/05/14  03:10:49  gpc-avc
 * Initial revision
 *
 * Revision 2.8  1993/04/30  05:08:38  gpc-avc
 * Restructured directories and Makefile
 *
 * Revision 2.6  1993/04/17  03:03:01  gpc-avc
 * Added a test to check if the fitness file exists
 *
 *
 */

#include <stdio.h>
#include <malloc.h>
#include <errno.h>
#include <stdlib.h>
#include "gpc.h"
#include "prob.h"
#include "math.h"

VOID load_fitness_file P_((
	char *fn,
	int *num,
	int **labels,
	GENERIC ***table,
        pop_struct *pop
	));

GENERIC **fitness_cases_table;
GENERIC **test_cases_table;
int *fclabels;
int *tclabels;
int numfc;
int numtc;
int global_terminate_flag = 0;

#define xabs(x) ((x)>0?(x):(-(x)))
#ifdef ANSI_FUNC

VOID evaluate_fitness_of_populations(
     int 	numpops,
     int 	numgens,
     pop_struct	*pop,
     int	p
     )
#else

VOID evaluate_fitness_of_populations(numpops,numgens,pop,p)
     int 	numpops;
     int 	numgens;
     pop_struct	*pop;
     int	p;
#endif
{
  int		i;

  for (i=0; i<pop[p].population_size; i++) {
    pop[p].standardized_fitness[i] = 
      evaluate_fitness_of_individual(pop,p,pop[p].population[i],i);
  }
}

#ifdef ANSI_FUNC

float evaluate_fitness_of_individual(
     pop_struct	*pop,
     int	p,
     tree	*t,
     int	i
     )
#else

float evaluate_fitness_of_individual(pop, p, t, i)
     pop_struct	*pop;
     int	p;
     tree	*t;
     int	i;
#endif
{
  int		j, correct;
  GENERIC	pdval;

  correct = 0;
  for (j=0; j<numfc; j++) {
    load_terminal_set_values(pop,p,fitness_cases_table[j]);
    if (eval(pop[p].population[i])>0.0) {
      if (fclabels[j])  correct++;
    } else {
      if (!(fclabels[j]))  correct++;
    }
  }
  return 1.0 - (((float) correct)/(float)numfc);
}

#ifdef ANSI_FUNC

float validate_fitness_of_tree(
     int	numpops,
     int	numgens,
     pop_struct *pop,
     int	p,
     tree 	*t
     )
#else

float validate_fitness_of_tree(numpops, numgens, pop, p, t)
  int		numpops;
  int		numgens;
  pop_struct	*pop;
  int		p;
  tree		*t;
#endif
{
  int	        j, correct, agree;
  float		optclass(), retval, optval;

  correct = agree = 0;
  for (j=0; j<numtc; j++) {
    load_terminal_set_values(pop,p,test_cases_table[j]);
    if ((retval = eval(t)) > 0.0) {
      if (tclabels[j])  correct++;
      if ((optval = optclass(test_cases_table[j][0],test_cases_table[j][1],
			     test_cases_table[j][2])) > 0.0) agree++;
    } else {
      if (!(tclabels[j]))  correct++;
      if ((optval = optclass(test_cases_table[j][0],test_cases_table[j][1],
			     test_cases_table[j][2])) <= 0.0) agree++;
    }
/*    write_tree(pop, p, pop[p].format, stdout);
    printf("\n fitness=%f; optimal=%f\n", retval, optval);
    getchar();
*/
  }
  if (agree == numtc) global_terminate_flag = 1; /* optimal solution found */
  return 1.0 - (((float) correct)/(float)numtc);
}
  
#ifdef ANSI_FUNC

int terminate_early(
  int 		numpops,
  int 		numgens,
  pop_struct 	*pop
  )
#else

int terminate_early(numpops,numgens,pop)
  int		numpops;
  int		numgens;
  pop_struct 	*pop;
#endif
{
  if (global_terminate_flag) {
    printf("\n*** OPTIMAL INDIVIDUAL FOUND ***\n");
  }
  return global_terminate_flag;
}

#ifdef ANSI_FUNC

VOID define_fitness_cases(
  int 		numpops,
  int 		numgens,
  pop_struct	*pop
     )
#else

VOID define_fitness_cases(numpops,numgens,pop)
  int 		numpops;
  int 		numgens;
  pop_struct	*pop;
#endif
{
  int	p,i;
  char	ffn[132],tfn[132];
  FILE	*f;

  printf("Enter name of fitness cases file: ");
  scanf("%s",ffn);
  printf("%s\n",ffn);
  printf("Enter name of validation test cases file: ");
  scanf("%s",tfn);
  printf("%s\n",tfn);
  load_fitness_file(ffn,&numfc,&fclabels,&fitness_cases_table,pop);
  load_fitness_file(tfn,&numtc,&tclabels,&test_cases_table,pop);
}

#ifdef ANSI_FUNC

VOID load_fitness_file(
  char *fn,
  int *num,
  int **labels,
  GENERIC ***table,
  pop_struct *pop
  )
#else

VOID load_fitness_file(fn,num,labels,table,pop)
char	*fn;
int	*num;
int	**labels;
GENERIC ***table;
pop_struct *pop;
#endif
{
  FILE	*f;
  int	i,j;
  int	p =0;

  if ((f=fopen(fn,"r")) == (FILE *) NULL) {
    fprintf(stderr,"Error: fitness file not found: %s\n",fn);
    exit(1);
  }
  fscanf(f,"%d",num);
  (*labels) = (int *) malloc(*num*sizeof(int));
  (*table) = (GENERIC **) malloc(*num*sizeof(GENERIC *));
  for (i = 0; i<*num; i++) {
    (*table)[i] = (GENERIC *) 
      malloc(pop[p].terminal_table_size*sizeof(GENERIC));
    fscanf(f,"%d",&((*labels)[i]));
    for (j=0;j<pop[p].terminal_table_size;j++) 
      fscanf(f,FORMAT,&((*table)[i][j]));
  }
  fclose(f);
}

float optclass(x,y,z) 
float	x,y,z;
{
  return (float)
    -(2.0*(sqrt((double)(x*x+y*y))-sqrt((double)((x-1.0)*(x-1.0)+z*z))-x)+1.0);
}
