/*
SGPC: Simple Genetic Programming in C
(c) 1993 by Walter Alden Tackett and Aviram Carmi
 
 This code and documentation is copyrighted and is not in the public domain.
 All rights reserved. 
 
 - This notice may not be removed or altered.
 
 - You may not try to make money by distributing the package or by using the
   process that the code creates.
 
 - You may not distribute modified versions without clearly documenting your
   changes and notifying the principal author.
 
 - The origin of this software must not be misrepresented, either by
   explicit claim or by omission.  Since few users ever read sources,
   credits must appear in the documentation.
 
 - Altered versions must be plainly marked as such, and must not be
   misrepresented as being the original software.  Since few users ever read
   sources, credits must appear in the documentation.
 
 - The authors are not responsible for the consequences of use of this 
   software, no matter how awful, even if they arise from flaws in it.
 
If you make changes to the code, or have suggestions for changes,
let us know!  (gpc@ipld01.hac.com)
*/

#ifndef lint
static char fitness_c_rcsid[]="$Id: fitness.c,v 2.8 1993/04/30 05:08:38 gpc-avc Exp gpc-avc $";
#endif

/*
 *
 * $Log: fitness.c,v $
 * Revision 2.8  1993/04/30  05:08:38  gpc-avc
 * Restructured directories and Makefile
 *
 * Revision 2.6  1993/04/17  03:03:01  gpc-avc
 * Added a test to check if the fitness file exists
 *
 *
 */

#include <stdio.h>
#include <malloc.h>
#include <errno.h>
#include <stdlib.h>
#include "gpc.h"
#include "prob.h"

VOID sort_fitness_cases P_((
	int num,
	GENERIC *vals,
	int *index
	));

VOID load_fitness_file P_((
	char *fn,
	int *num,
	int **labels,
	GENERIC ***table,
	GENERIC **tval,
	GENERIC **cval,
	int **tindex,
	int **cindex,
	int *numt,
	int *numc
	));

#define DIMENSION 7
GENERIC **fitness_cases_table;
GENERIC **test_cases_table;
int *fclabels;
int *tclabels;
int numfc;
int numtc;

GENERIC *fctval;
GENERIC *fccval;
GENERIC *tctval;
GENERIC *tccval;
GENERIC *sortval;
int *fct_sort_index;
int *fcc_sort_index;
int *tct_sort_index;
int *tcc_sort_index;
int numfct;
int numfcc;
int numtct;
int numtcc;

#define pd 0.96
#define xabs(x) ((x)>0?(x):(-(x)))
#ifdef ANSI_FUNC

VOID evaluate_fitness_of_populations(
     int 	numpops,
     int 	numgens,
     pop_struct	*pop,
     int	p
     )
#else

VOID evaluate_fitness_of_populations(numpops,numgens,pop,p)
     int 	numpops;
     int 	numgens;
     pop_struct	*pop;
     int	p;
#endif
{
  int		i;

  for (i=0; i<pop[p].population_size; i++) {
    pop[p].standardized_fitness[i] = 
      evaluate_fitness_of_individual(pop,p,pop[p].population[i],i);
  }
}

#ifdef ANSI_FUNC

float evaluate_fitness_of_individual(
     pop_struct	*pop,
     int	p,
     tree	*t,
     int	i
     )
#else

float evaluate_fitness_of_individual(pop, p, t, i)
     pop_struct	*pop;
     int	p;
     tree	*t;
     int	i;
#endif
{
  int		j, ccount, tcount;
  GENERIC	pdval;

  ccount = tcount = 0;
  for (j=0; j<numfc; j++) {
    load_terminal_set_values(pop,p,fitness_cases_table[j]);
    if (fclabels[j]) fctval[tcount++] = eval(pop[p].population[i]);
    else fccval[ccount++] = eval(pop[p].population[i]);
  }
  sort_fitness_cases(tcount, fctval, fct_sort_index);
  sort_fitness_cases(ccount, fccval, fcc_sort_index);
  pdval = fctval[fct_sort_index[(int)((pd*((GENERIC)(tcount-1)))+0.5)]];
  for (j=0; ((j<ccount) && (fccval[fcc_sort_index[j]] >= pdval)); j++);
  return ((float)j)/(float)ccount;
}

#ifdef ANSI_FUNC

float validate_fitness_of_tree(
     int	numpops,
     int	numgens,
     pop_struct *pop,
     int	p,
     tree 	*t
     )
#else

float validate_fitness_of_tree(numpops, numgens, pop, p, t)
  int		numpops;
  int		numgens;
  pop_struct	*pop;
  int		p;
  tree		*t;
#endif
{
  int	        j, ccount, tcount;
  GENERIC	pdval;

  ccount = tcount = 0;
  for (j=0; j<numtc; j++) {
    load_terminal_set_values(pop,p,test_cases_table[j]);
    if (tclabels[j]) tctval[tcount++] = eval(t);
      else tccval[ccount++] = eval(t);
    }
  sort_fitness_cases(tcount, tctval, tct_sort_index);
  sort_fitness_cases(ccount, tccval, tcc_sort_index);
  pdval = tctval[tct_sort_index[(int)((pd*((GENERIC)(tcount-1)))+0.5)]];
  for (j=0; ((j<ccount) && (tccval[tcc_sort_index[j]] >= pdval)); j++);
  printf("Validation Fitness:\np(D)= %f p(FA)= %f\n", pd, ((float)j)/(float)ccount);
  return ((float)j)/(float)ccount;
}
  
#ifdef ANSI_FUNC

static int fcpr(
	int *i,
	int *j
	)
#else

static int fcpr(i, j)
int	*i, *j;
#endif
{
  if (sortval[*j] > sortval[*i]) return 1;
  else if (sortval[*j] < sortval[*i]) return -1;
  else return 0;
}

#ifdef ANSI_FUNC

VOID sort_fitness_cases(
	int num,
	GENERIC *vals,
	int *index
	)
#else

VOID sort_fitness_cases(num, vals, index)
int	num;
GENERIC *vals;
int	*index;
#endif
{
  int	i;

  for (i=0; i<num;i++) {
    index[i] = i;
  }
  sortval = vals;
  qsort(index, num, sizeof(int), fcpr);
}

#ifdef ANSI_FUNC

int terminate_early(
  int 		numpops,
  int 		numgens,
  pop_struct 	*pop
  )
#else

int terminate_early(numpops,numgens,pop)
  int		numpops;
  int		numgens;
  pop_struct 	*pop;
#endif
{
  return 0;
}

#ifdef ANSI_FUNC

VOID define_fitness_cases(
  int 		numpops,
  int 		numgens,
  pop_struct	*pop
     )
#else

VOID define_fitness_cases(numpops,numgens,pop)
  int 		numpops;
  int 		numgens;
  pop_struct	*pop;
#endif
{
  int	p,i;
  char	ffn[132],tfn[132];
  FILE	*f;

  printf("Enter name of fitness cases file: ");
  scanf("%s",ffn);
  printf("%s\n",ffn);
  printf("Enter name of validation test cases file: ");
  scanf("%s",tfn);
  printf("%s\n",tfn);
  load_fitness_file(ffn,&numfc,&fclabels,&fitness_cases_table,
		    &fctval, &fccval, &fct_sort_index, &fcc_sort_index,
		    &numfct, &numfcc);
  load_fitness_file(tfn,&numtc,&tclabels,&test_cases_table,
		    &tctval, &tccval, &tct_sort_index, &tcc_sort_index,
		    &numtct, &numtcc);
}

#ifdef ANSI_FUNC

VOID load_fitness_file(
	char *fn,
	int *num,
	int **labels,
	GENERIC ***table,
	GENERIC **tval,
	GENERIC **cval,
	int **tindex,
	int **cindex,
	int *numt,
	int *numc
	)
#else

VOID load_fitness_file(fn,num,labels,table,tval,cval,tindex, cindex,numt,numc)
char	*fn;
int	*num;
int	**labels;
GENERIC ***table;
GENERIC **tval, **cval;
int	**tindex, **cindex;
int	*numt, *numc;
#endif
{
  FILE	*f;
  int	i,j;

  if ((f=fopen(fn,"r")) == (FILE *) NULL) {
    fprintf(stderr,"Error: fitness file not found: %s\n",fn);
    exit(1);
  }
  fscanf(f,"%d",num);
  (*labels) = (int *) malloc(*num*sizeof(int));
  (*table) = (GENERIC **) malloc(*num*sizeof(GENERIC *));
  for ((*numt) = (*numc) = i = 0; i<*num; i++) {
    (*table)[i] = (GENERIC *) malloc(DIMENSION*sizeof(GENERIC));
    fscanf(f,"%d",&((*labels)[i]));
    (((*labels)[i]) ? (*numt)++ : (*numc)++);
    for (j=0;j<DIMENSION;j++) fscanf(f,FORMAT,&((*table)[i][j]));
  }
  (*tval) = (GENERIC *) malloc(*numt*sizeof(GENERIC));
  (*cval) = (GENERIC *) malloc(*numc*sizeof(GENERIC));
  (*tindex) = (int *) malloc(*numt*sizeof(int));
  (*cindex) = (int *) malloc(*numc*sizeof(int));
  fclose(f);
}

