/*
SGPC: Simple Genetic Programming in C
(c) 1993 by Walter Alden Tackett and Aviram Carmi
 
 This code and documentation is copyrighted and is not in the public domain.
 All rights reserved. 
 
 - This notice may not be removed or altered.
 
 - You may not try to make money by distributing the package or by using the
   process that the code creates.
 
 - You may not distribute modified versions without clearly documenting your
   changes and notifying the principal author.
 
 - The origin of this software must not be misrepresented, either by
   explicit claim or by omission.  Since few users ever read sources,
   credits must appear in the documentation.
 
 - Altered versions must be plainly marked as such, and must not be
   misrepresented as being the original software.  Since few users ever read
   sources, credits must appear in the documentation.
 
 - The authors are not responsible for the consequences of use of this 
   software, no matter how awful, even if they arise from flaws in it.
 
If you make changes to the code, or have suggestions for changes,
let us know!  (gpc@ipld01.hac.com)
*/

#ifndef lint
static char treeops_c_rcsid[]="$Id: treeops.c,v 2.6 1993/04/14 04:42:52 gpc-avc Exp gpc-avc $";
#endif

/*
 *
 * $Log: treeops.c,v $
 * Revision 2.6  1993/04/14  04:42:52  gpc-avc
 * Fixed side effect of read_tree() modifying the random seed.
 * replaced global references to POP by the arg pop
 *
 *
 */

#include <stdio.h>
#include <malloc.h>
#include <errno.h>
#include "gpc.h"



#ifdef ANSI_FUNC

tree *create_tree_node(
  int pop,
  int nodetype,
  int id
  )
#else

tree *create_tree_node(pop, nodetype, id)
  int	pop;
  int	nodetype;
  int	id;
#endif
{
  tree	*t;
  
  if ((t = (tree *) malloc(sizeof(tree))) == NULL) {
    perror(" at point 1 in create_tree_node() <treeops.c>");
    exit(errno);
  }
  
  t->nodetype = nodetype;
  t->id = id;
  t->pop = pop;

  switch (nodetype) {
  case FUNCTION:
    init_function(t);
    break;
  case TERMINAL:
    init_terminal(t);
    break;
  default:
    fprintf(stderr,
	    "nodetype %d must be %d or %d in create_tree_node() <treeops.c>\n",
	    nodetype, FUNCTION, TERMINAL);
  }
  
  return t;
}

#ifdef ANSI_FUNC

VOID init_function(
  tree *t
  )
#else

VOID init_function(t)
  tree	*t;
#endif
{
  pop_struct *pop = POP;
 
  if ((t->id < 0) || (t->id >= pop[t->pop].function_table_size)) {
    fprintf(stderr,
	    "id %d must be >= 0 and < %d in init_function() <treeops.c>\n",
	    t->id, pop[t->pop].function_table_size);
  }

  
  if ((t->type.func = (function *) malloc(sizeof(function))) == NULL) {
    perror(" at point 1 in init_function() <treeops.c>");
    exit(errno);
  }
  
  if ((t->type.func->arg =
       (tree **) malloc(function_arity(t) * sizeof(tree *))) == NULL) {
    perror(" at point 2 in init_function() <treeops.c>");
    exit(errno);
  }
  
  if ((t->type.func->argvals =
       (GENERIC *) malloc(function_arity(t) * sizeof(GENERIC))) == NULL) {
    perror(" at point 3 in init_function() <treeops.c>");
    exit(errno);
  }
}

#ifdef ANSI_FUNC

VOID init_terminal(
  tree 	*t
)
#else

VOID init_terminal(t)
  tree	*t;
#endif
{
  pop_struct *pop = POP;
  GENERIC junk = -999999;

  /* t->id == terminal_table_size indicates that this terminal is a constant
     rather than a variable */

  if ((t->id < 0) || (t->id > pop[t->pop].terminal_table_size)) {
    fprintf(stderr,
	    "id %d must be >= 0 and <= %d in init_terminal() <treeops.c>\n",
	    t->id, pop[t->pop].terminal_table_size);
  }
  
  if ((t->type.term = (terminal *) malloc(sizeof(terminal))) == NULL) {
    perror(" at point 1 in init_terminal() <treeops.c>");
    exit(errno);
  }
  
  if (terminal_is_constant(t)) {
    if ((t->type.term->valptr = (GENERIC *) malloc(sizeof(GENERIC))) == NULL) {
      perror(" at point 2 in init_terminal() <treeops.c>");
      exit(errno);
    }
    /* stick a junk value into value pointer.  this may be replaced by the
       constant read from a file (if called by read_tree()) or the constant
       value of the leaf being copied (if called by copy_tree()) or
       by a random value if called form create_random_tree */
      *(t->type.term->valptr) = junk;
  } else {
    t->type.term->valptr = &(terminal_val(t));
  }
}

#ifdef ANSI_FUNC

tree *copy_tree(
	tree *t
	)
#else

tree *copy_tree(t)
tree   *t;
#endif
{
  switch (t->nodetype) {
  case FUNCTION:
    return copy_function(t);
  case TERMINAL:
    return copy_terminal(t);
  default:
    fprintf(stderr,
	    "nodetype %d must be %d or %d in copy_tree() <treeops.c>\n",
	    t->nodetype, FUNCTION, TERMINAL);
    return (tree *) NULL;
  }
}

#ifdef ANSI_FUNC

tree *copy_function(
  tree *t
  )
#else

tree *copy_function(t)
  tree *t;
#endif
{
  tree *nt;
  int  i;
  pop_struct *pop = POP;
  
  nt = create_tree_node(t->pop,t->nodetype, t->id);
  for (i=0; i < function_arity(t); i++ ) {
    nt->type.func->arg[i] = copy_tree(t->type.func->arg[i]);
  }
  return nt;
}


#ifdef ANSI_FUNC

tree *copy_terminal(
  tree *t
  )
#else

tree *copy_terminal(t)
  tree *t;
#endif
{
  tree *nt;
  pop_struct *pop = POP;
  
  nt = create_tree_node(t->pop,t->nodetype, t->id);
  if (terminal_is_constant(t)) {
    *(nt->type.term->valptr) = (*(t->type.term->valptr));
  }
  return nt;
}


#ifdef ANSI_FUNC

VOID free_tree(
  tree *t
  )
#else

VOID free_tree(t)
  tree   *t;
#endif
{
  switch (t->nodetype) {
  case FUNCTION:
    free_function(t);
    break;
  case TERMINAL:
    free_terminal(t);
    break;
  default:
    fprintf(stderr,
	    "nodetype %d must be %d or %d in free_tree() <treeops.c>\n",
	    t->nodetype, FUNCTION, TERMINAL);
  }
}

#ifdef ANSI_FUNC

VOID free_function(
  tree *t
  )
#else

VOID free_function(t)
  tree *t;
#endif
{
  int  i;
  pop_struct *pop = POP;
  
  for (i=0; i < function_arity(t); i++ ) {
    free_tree(t->type.func->arg[i]);
  }
  free(t->type.func->arg);
  free(t->type.func->argvals);
  free(t->type.func);
  free(t);
}

#ifdef ANSI_FUNC

VOID free_terminal(
  tree *t
  )
#else

VOID free_terminal(t)
  tree *t;
#endif
{
  pop_struct *pop = POP;

  if (terminal_is_constant(t)) {
    free(t->type.term->valptr);
  }
  free(t->type.term);
  free(t);
}
