/*
SGPC: Simple Genetic Programming in C
(c) 1993 by Walter Alden Tackett and Aviram Carmi
 
 This code and documentation is copyrighted and is not in the public domain.
 All rights reserved. 
 
 - This notice may not be removed or altered.
 
 - You may not try to make money by distributing the package or by using the
   process that the code creates.
 
 - You may not distribute modified versions without clearly documenting your
   changes and notifying the principal author.
 
 - The origin of this software must not be misrepresented, either by
   explicit claim or by omission.  Since few users ever read sources,
   credits must appear in the documentation.
 
 - Altered versions must be plainly marked as such, and must not be
   misrepresented as being the original software.  Since few users ever read
   sources, credits must appear in the documentation.
 
 - The authors are not responsible for the consequences of use of this 
   software, no matter how awful, even if they arise from flaws in it.
 
If you make changes to the code, or have suggestions for changes,
let us know!  (gpc@ipld01.hac.com)
*/

#ifndef lint
static char mutation_c_rcsid[]="$Id: mutation.c,v 2.4 1993/04/14 04:54:06 gpc-avc Exp gpc-avc $";
#endif

/*
 *
 * $Log: mutation.c,v $
 * Revision 2.4  1993/04/14  04:54:06  gpc-avc
 * Finished mods for checkpointing
 * added format to write tree
 *
 *
 */

#include <stdio.h>
#include <malloc.h>
#include <errno.h>
#include "gpc.h"



/* #define TRACEm */
#ifdef ANSI_FUNC

tree *mutate(
  pop_struct	*pop,
  tree 		*t
  )
#else

tree *mutate(pop, t)
  pop_struct	*pop;
  tree		*t;
#endif
{
  int	mpt;
  tree	*st, **stptr, *newst;

  mpt = random_int(count_crossover_pts(t));

#ifdef TRACEm
  printf("mpt = %d\n",mpt);
#endif

  st = get_subtree(t, mpt);

#ifdef TRACEm
  printf("subtree to be replaced:\n");
  write_tree(pop, st, pop[p].format, stdout);
#endif

  stptr = pointer_to_subtree(&t, st);

  /* note: unlike Koza/Rice we call this with root_p == 0, allowing a
     leaf to be substituted for the subtree we're snipping out */
  newst = create_random_tree(pop, t->pop, pop[t->pop].max_mutant_depth, 0, 0);

#ifdef TRACEm
  printf("new subtree:\n");
  write_tree(pop, newst, pop[p].format, stdout);
#endif

  free_tree(st);
  *stptr = newst;
  /* we return the value of t, since it may have changed */
  return t;
}
#undef TRACEm
