% setup_display.m

global axwt axhist cr_button bkg_button evboxes

colordef none
clf reset, whitebg(gcf,[0 0 0])
set(gcf,'Position',[5 100 560 620]), figure(gcf)
set(gcf,'Name','Rescorla-Wagner Simulator')

groupinc = 150;
toprow = 280;
xinc = 50;
yinc = 25;
stimcolors = 'cmry';

xpos = 10 - xinc;
for j = 1:2
    for i = 1:5
        ypos = toprow-(j-1)*groupinc;
        cs1 = uicontrol('Style','CheckBox','String','cs1', ...
            'Position',[xpos+1*xinc ypos-i*yinc 50 20],'UserData',stimcolors(1), ...
            'CallBack','toggle(gcbo)');
        cs2 = uicontrol('Style','CheckBox','String','cs2', ...
            'Position',[xpos+2*xinc ypos-i*yinc 50 20],'UserData',stimcolors(2), ...
            'CallBack','toggle(gcbo)');
        cs3 = uicontrol('Style','CheckBox','String','cs3', ...
            'Position',[xpos+3*xinc ypos-i*yinc 50 20],'UserData',stimcolors(3), ...
            'CallBack','toggle(gcbo)');
        ucs = uicontrol('Style','CheckBox','String','ucs', ...
            'Position',[xpos+4*xinc ypos-i*yinc 50 20],'UserData',stimcolors(4), ...
            'CallBack','toggle(gcbo)');
        go  = uicontrol('Style','PushButton','String','Train', ...
            'Position',[xpos+5*xinc ypos-i*yinc 42 20], ...
            'BackgroundColor',[0.2 0.8 0.2], ...
            'CallBack','train_case(gcbo);record_weights;disp_weights');
        evbox = uicontrol('Style','Text', ...
            'Position',[xpos+6*xinc ypos-i*yinc 40 20]);
        go_buttons(i,j) = go;
        set(go,'UserData',[cs1 cs2 cs3 ucs])
        evboxes(i,j) = evbox;
        set(evbox,'UserData',[cs1 cs2 cs3 ucs])
    end
    allgo = uicontrol('Style','PushButton','String','All', ...
        'Position',[xpos+7*xinc ypos-3*yinc 35 (3-0.1)*yinc], ...
        'BackgroundColor',[0.2 0.8 0.2], ...
        'CallBack','train_all(gcbo,1);disp_weights');
    set(allgo,'UserData',go_buttons(:,j)')
    all_10x = uicontrol('Style','PushButton','String','10x', ...
        'Position',[xpos+7*xinc ypos-5*yinc 35 (2-0.1)*yinc], ...
        'BackgroundColor',[0.2 0.8 0.2], ...
        'CallBack','train_all(gcbo,10);disp_weights');
    set(all_10x,'UserData',go_buttons(:,j)')
end

expos = xpos + 10*xinc;
boxinc = 25;
tcolors = ['w' stimcolors];
for i = 1:5
    aboxes(i) = uicontrol('Style','Edit', ...
        'Position',[expos toprow-i*boxinc 50 22], ...
        'String',num2str(Coeffs(i)), 'Value',(Coeffs(i)), ...
        'CallBack','set_boxval(gcbo)');
    set(aboxes(i),'UserData',i)
    if i < 5
        tstr = ['alpha' num2str(i-1)];
    else
        tstr = 'beta';
    end
    tboxes(i) = uicontrol('Style','Text', 'String',tstr, ...
        'BackgroundColor',[0 0 0], 'ForeGroundColor',tcolors(i), ...
        'Position',[expos-60 toprow-i*boxinc 60 22]);
end

start_button = uicontrol('Style','PushButton','String','Start', ...
    'Position',[expos-90 toprow-7*boxinc 50 30], ...
    'BackgroundColor',[0.95 0.5 0.1], 'CallBack','new_expt');

mark_button = uicontrol('Style','PushButton','String','Mark', ...
    'Position',[expos-30 toprow-7*boxinc 50 30], ...
    'BackgroundColor',[0.95 0.95 0.1], 'CallBack','mark_epoch');
 
clear_button = uicontrol('Style','PushButton','String','Clear', ...
    'Position',[expos+30 toprow-7*boxinc 50 30], ...
    'BackgroundColor',[0.95 0.5 0.1], 'CallBack','reset_rw');

cr_button = uicontrol('Style','CheckBox','String','No CR < 0', ...
    'Position',[expos-60 toprow-9*boxinc 110 25],'Value',1, ...
    'UserData',[0.9 0.5 0.5],'CallBack','toggle(gcbo)');

bkg_button = uicontrol('Style','CheckBox','String','No bkg < 0', ...
    'Position',[expos-60 toprow-10*boxinc 110 25],'Value',1, ...
    'UserData',[0.9 0.5 0.5],'CallBack','toggle(gcbo)');

toggle(cr_button)
toggle(bkg_button)


axwt = axes('Position',[0.07 0.5 0.3 0.45]);
axhist = axes('Position',[0.5 0.5 0.45 0.45]);
