plotbgcolor = [.0 .8 .6];
stimcolor = [.0 .5 .7];
paramcolor = [0.5 0 0.2];

figure(2)
clf
set(gcf,'Color',stimcolor)
p = get(gcf,'Position');
set(gcf,'Position',[p(1:2) 500 400])

uicontrol('Style','Text', ...
    'Position',[100 350 400 40], ...
    'String','Stimulus Parameters', ...
    'FontName','Helvetica','FontSize',18, ...
    'FontWeight','bold', ...
    'ForegroundColor','y','BackgroundColor',stimcolor)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

uicontrol('Style','Text', ...
    'Position',[5 290 40 20], 'String','Stim', ...
    'HorizontalAlignment','Right', ...
    'ForegroundColor','y','BackgroundColor',stimcolor)

ht1stim1 = uicontrol('Style','ListBox', ...
    'Position',[50 250 80 70], ...
    'Value',1, 'Max',4, ...
    'String',{'CS 1','CS 2','US','---'});

uicontrol('Style','Text', ...
    'Position',[5 225 40 20], 'String','Dur', ...
    'HorizontalAlignment','Right', ...
    'ForegroundColor','y','BackgroundColor',stimcolor)

ht1dur1 = uicontrol('Style','Edit', ...
    'Position',[50 230 80 20], ...
    'String','6', 'Value', 6, ...
    'CallBack','set_numeric(gcbo)');

uicontrol('Style','Text', ...
    'Position',[5 205 40 20], 'String','ISI', ...
    'HorizontalAlignment','Right', ...
    'ForegroundColor','y','BackgroundColor',stimcolor)

ht1isi =  uicontrol('Style','Edit', ...
    'Position',[50 210 100 20], ...
    'String','10', 'Value', 10, ...
    'CallBack','set_numeric(gcbo)');

ht1stim2 = uicontrol('Style','ListBox', ...
    'Position',[150 250 80 70], ...
    'Value',3, 'Max',4, ...
    'String',{'CS 1','CS 2','US','---'});

ht1dur2 = uicontrol('Style','Edit', ...
    'Position',[150 230 80 20], ...
    'String','6', 'Value', 6, ...
    'CallBack','set_numeric(gcbo)');

uicontrol('Style','Text', ...
    'Position',[190 205 40 20], 'String','ITI', ...
    'HorizontalAlignment','Right', ...
    'ForegroundColor','y','BackgroundColor',stimcolor)

ht1iti =  uicontrol('Style','Edit', ...
    'Position',[230 210 100 20], ...
    'String','200', 'Value', 200, ...
    'CallBack','set_numeric(gcbo)');

uicontrol('Style','Text', ...
    'Position',[290 280 40 20], 'String','# Trials', ...
    'HorizontalAlignment','Right', ...
    'ForegroundColor','y','BackgroundColor',stimcolor)

ht1trials = uicontrol('Style','Edit', ...
    'Position',[330 285 80 20], ...
    'String','12', 'Value', 12, ...
    'CallBack','set_numeric(gcbo)');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

uicontrol('Style','Text', ...
    'Position',[5 90 40 20], 'String','Stim', ...
    'HorizontalAlignment','Right', ...
    'ForegroundColor','y','BackgroundColor',stimcolor)

ht2stim1 = uicontrol('Style','ListBox', ...
    'Position',[50 50 80 70], ...
    'Value',[1 2], 'Max',4, ...
    'String',{'CS 1','CS 2','US','---'});

uicontrol('Style','Text', ...
    'Position',[5 25 40 20], 'String','Dur', ...
    'HorizontalAlignment','Right', ...
    'ForegroundColor','y','BackgroundColor',stimcolor)

ht2dur1 = uicontrol('Style','Edit', ...
    'Position',[50 30 80 20], ...
    'String','6', 'Value', 6, ...
    'CallBack','set_numeric(gcbo)');

uicontrol('Style','Text', ...
    'Position',[5 5 40 20], 'String','ISI', ...
    'HorizontalAlignment','Right', ...
    'ForegroundColor','y','BackgroundColor',stimcolor)

ht2isi =  uicontrol('Style','Edit', ...
    'Position',[50 10 100 20], ...
    'String','10', 'Value', 10, ...
    'CallBack','set_numeric(gcbo)');

ht2stim2 = uicontrol('Style','ListBox', ...
    'Position',[150 50 80 70], ...
    'Value',3, 'Max',4, ...
    'String',{'CS 1','CS 2','US','---'});

ht2dur2 = uicontrol('Style','Edit', ...
    'Position',[150 30 80 20], ...
    'String','6', 'Value', 6, ...
    'CallBack','set_numeric(gcbo)');

uicontrol('Style','Text', ...
    'Position',[190 5 40 20], 'String','ITI', ...
    'HorizontalAlignment','Right', ...
    'ForegroundColor','y','BackgroundColor',stimcolor)

ht2iti =  uicontrol('Style','Edit', ...
    'Position',[230 10 100 20], ...
    'String','200', 'Value', 200, ...
    'CallBack','set_numeric(gcbo)');

uicontrol('Style','Text', ...
    'Position',[290 55 40 20], 'String','# Trials', ...
    'HorizontalAlignment','Right', ...
    'ForegroundColor','y','BackgroundColor',stimcolor)

ht2trials = uicontrol('Style','Edit', ...
    'Position',[330 60 80 20], ...
    'String','7', 'Value', 7, ...
    'CallBack','set_numeric(gcbo)');

px = 345; py = 250;

uicontrol('Style','Frame','Position',[345 90 150 190], ...
    'BackgroundColor',paramcolor)

py = make_param(px,py,'beta1',beta1,paramcolor);
py = make_param(px,py,'beta2',beta2,paramcolor);
py = make_param(px,py,'delta1',delta1,paramcolor);
py = make_param(px,py,'delta2',delta2,paramcolor);
py = make_param(px,py,'theta',theta,paramcolor);
py = make_param(px,py,'Rthresh',Rthresh,paramcolor);
py = make_param(px,py,'Rtheta',Rtheta,paramcolor);
py = make_param(px,py,'Vinit',Vinit,paramcolor);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

hrun = uicontrol('Style','PushButton', ...
    'Position',[450 5 45 30], ...
    'String','Run', ...
    'ForegroundColor','k', 'BackgroundColor',plotbgcolor, ...
    'Callback','execute_model; update_history; display_results');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

figure(1), clf
zoomscale = 1;
set(gcf,'Color',plotbgcolor)
ax1=subplot(6,1,1);
ax2=subplot(6,1,2);
ax3=subplot(6,1,3);
ax4=subplot(6,1,4);
ax5=subplot(6,1,5);
ax6=subplot(6,1,6);

figpos = get(gcf,'position');
hscroll = uicontrol('Style','Slider', ...
    'Units','normalized','Position',[0.3 0 0.6 20/figpos(4)], ...
    'SliderStep',[0.1 99], ...
    'Callback','scroll_display');

uicontrol('Style','PushButton', ...
    'Position',[5 5 60 20],'String','Zoom In', ...
    'CallBack','zoomscale = zoomscale/2; scroll_display;')

uicontrol('Style','PushButton', ...
    'Position',[70 5 60 20],'String','Zoom Out', ...
    'CallBack','zoomscale = zoomscale*2; scroll_display;')

haccum = uicontrol('Style','checkbox', ...
    'Position',[135 5 60 20],'String','Mean', ...
    'Value', 0, ...
    'BackgroundColor',[0.8 0.8 0.2], ...
    'CallBack','reset_mean;display_results');
