% scroll_display.m

zoomscale = max(10/stim_time,min(1,zoomscale));

stepsize = 1/(max(1/zoomscale-1,1e-5));
arrowstep = min(0.1,zoomscale*.1);
set(hscroll,'SliderStep',[arrowstep stepsize])

v = get(hscroll,'Value');

vmin = v * (1/zoomscale-1)*zoomscale;

vmax = min(1,vmin+zoomscale);

xmin = floor(vmin*stim_time);
xmax = ceil(vmax*stim_time);
newax = [xmin xmax 0 1.1];

subplot(ax1), axis(newax)
subplot(ax2), axis(newax)
subplot(ax3), axis(newax)
subplot(ax4), axis(newax)
subplot(ax5), axis(newax)
subplot(ax6), axis(newax)
