% display_results.m

figure(1)
subplot(ax1), cla, box on
plot_spikes(Scs), leg1=legend('S');
title('Classical Conditioning in Aplysia', ...
    'Color',[.6 .4 .1], ...
    'FontWeight','Bold', 'FontSize',18)

subplot(ax2), cla, box on
plot_spikes(Pcs), leg2=legend('P');

subplot(ax3), cla, hold on, box on
usidx = find(US);
hb = [];
if ~isempty(usidx)
  hb=bar(usidx+0.5,ones(length(usidx),1),1,'r');
  set(hb,'EdgeColor','r')
end
htcs=plot(Tcs);
hphi=plot(Phics(:,1),'m');
plot(Phics(:,2),'g')
leg3=legend([htcs(1),hphi,hb],{'T','\Phi','US'}); box on

subplot(ax4), cla, hold on, box on
plot_spikes(Sfi)
plot(Afi,'r')
plot(Rfi,'m')
leg4=legend('S_{fi}','A_{fi}','R_{fi}');

subplot(ax5), cla, box on
plot(Amn,'r')
leg5=legend('A_{mn}');

subplot(ax6), cla, box on
plot(V)
leg6=legend('V');

fixwidth(ax1,leg1)
fixwidth(ax2,leg2)
fixwidth(ax3,leg3)
fixwidth(ax4,leg4)
fixwidth(ax5,leg5)
fixwidth(ax6,leg6)

scroll_display
