% scroll_display.m

zoomscale = max(10/stim_time,min(1,zoomscale));

stepsize = 1/(max(1/zoomscale-1,1e-5));
arrowstep = min(0.1,zoomscale*.1);
set(hscroll,'SliderStep',[arrowstep stepsize])

v = get(hscroll,'Value');

vmin = v * (1/zoomscale-1)*zoomscale;

vmax = min(1,vmin+zoomscale);

xmin = floor(vmin*stim_time);
xmax = ceil(vmax*stim_time);
newax = [xmin xmax];

subplot(ax1), ax=axis; axis([newax ax(3:4)])
subplot(ax2), ax=axis; axis([newax ax(3:4)])
subplot(ax3), ax=axis; axis([newax ax(3:4)])
subplot(ax4), ax=axis; axis([newax ax(3:4)])
subplot(ax5), ax=axis; axis([newax ax(3:4)])
subplot(ax6), ax=axis; axis([newax ax(3:4)])
