% display_results.m

figure(1)
subplot(ax1), cla, box on
plot_spikes([Scs(:,1), -Scs(:,2)]), leg1=legend('S1','S2');
axis([0 rows -1.1 1.1])
title('Classical Conditioning in Aplysia', ...
    'Color',[.6 .4 .1], ...
    'FontWeight','Bold', 'FontSize',18)

subplot(ax2), cla, box on
plot_spikes([Pcs(:,1), -Pcs(:,2)]), leg2=legend('P1','P2');
axis([0 rows -1.1 1.1])

subplot(ax3), cla, hold on, box on
usidx = find(US);
hb = [];
if ~isempty(usidx)
  hb=bar(usidx+0.5,ones(length(usidx),1),1,'r');
  set(hb,'EdgeColor','r')
end
htcs=plot([Tcs(:,1), -Tcs(:,2)]);
hphi=plot(Phics(:,1),'m');
plot(-Phics(:,2),'g')
axis([0 rows -1.1 1.1])
leg3=legend([htcs(1),hphi,hb],{'T','\Phi','US'}); box on

subplot(ax4), cla, hold on, box on
plot_spikes(Sfi)
plot(Rfi,'m')
plot(Afihist/total_runs,'r')
axis([0 rows 0 1.1])
leg4=legend('S_{fi}','R_{fi}','A_{fi}');

subplot(ax5), cla, box on
plot(Amnhist/total_runs,'r')
axis([0 rows 0 1])
leg5=legend('A_{mn}');

subplot(ax6), cla, box on
plot(Vhist/total_runs)
axis([0 rows 0 1])
leg6=legend('V');
if total_runs > 1
  xlabel(sprintf('Average over %d Runs',total_runs), ...
      'Color','y','BackgroundColor','k')
end

fixwidth(ax1,leg1)
fixwidth(ax2,leg2)
fixwidth(ax3,leg3)
fixwidth(ax4,leg4)
fixwidth(ax5,leg5)
fixwidth(ax6,leg6)

scroll_display
