% setup_display

clf reset
blackBackground
set(gcf,'Backingstore','off')

axis([1 NEUNITS 0 1])
hold on
set(gca,'Position',[0.1 0.2 0.8 0.7])
set(gca,'ButtonDownFcn','clickhandler')
xlabel('Use the mouse to supply external input')

h_bump = plot(zeros(NEUNITS,1),'yo', ...
	'ButtonDownFcn','clickhandler');
h_inhib = plot([0 NEUNITS],[0 0],'c', ...
	'ButtonDownFcn','clickhandler');
h_inp = plot(zeros(NEUNITS,1),'r','LineWidth',2,...
	'ButtonDownFcn','clickhandler');
h_title = title('');

bias_slider = uicontrol('Style','Slider','Tag','Bias', ...
  'Position', [90 30 150 16], 'Value', 0.5, ...
  'CallBack','Bias = update_slider(gcbo,bias_text, -0.5,  0.5,  0.01,  ''Bias: %5.2f'');');
bias_text = uicontrol('Style','Text','Position',[250 30 80 16], ...
		      'String','No Bias');


noise_slider = uicontrol('Style','Slider','Tag','Noise', ...
  'Position', [90 10 150 16], 'Value', 0.0, ...
  'SliderStep', [0.05 0.1], ...
  'CallBack','Noise = update_slider(gcbo,noise_text,0, 2, 0.1, ''Noise: %4.1f'');');
noise_text = uicontrol('Style','Text','Position',[250 10 80 16], ...
		       'String','No Noise');


run_button = uicontrol('Style','PushButton','Position',[10 50 40 18], ...
	'BackgroundColor',[.2 .8 .2],'String','Run', ...
	'CallBack','run_flag = Inf; bump_mainloop');

step_button = uicontrol('Style','PushButton','Position',[10 30 40 18], ...
	'BackgroundColor',[.5 .5 1],'String','Step', ...
	'CallBack','run_flag = 1; bump_mainloop; update_title');

rand_button = uicontrol('Style','PushButton','Position',[10 10 40 18], ...
	'BackgroundColor',[.8 .2 .2],'String','Rand', ...
	'CallBack','random_act');

hold_pushbutton = uicontrol('Style','Checkbox', ...
        'Position',[400 19 90 20], 'String', 'Input Hold');
