function init_graphics
  global axplot axbuttons axdata axparams buttons PAUSE_FLAG

  PAUSE_FLAG = 0;

  clf reset
  set(gcf,'Name','Synaptic Learning Rules')
  bgcol = [0 0 0]; whitebg(gcf,bgcol); set(gcf,'Color',bgcol)

  axplot = axes('Position',[0.05 0.40 0.6 0.5]); axis off
  axdata = axes('Position',[0.05 0.15 0.6 0.2]); axis off
  axbuttons = axes('Position',[0 0 0.6 0.39]); axis off
  axparams = axes('Position',[0 0 1 1]); axis off

  subplot(axbuttons)
  buttons.c1 = ...
      uicontrol('Style','PopUp', ...
		'Units','pixels', 'Position',[10 10 100 25], ...
		'String',{'none','Hebb','covar','BCM'}, ...
		'CallBack','label_all_buttons', ...
		'UserData', ...
		{{'','0'}, ...
		 {'\alpha y_A y_B','Params.alpha * y_A * y_B'}, ...
		 {'\alpha (y_A-\mu_A) (y_B-\mu_B)', ...
		  'Params.alpha * (y_A - mu_A) * (y_B - mu_B)'}, ...
		 {'\alpha y_A \Phi(y_B,\theta)', ...
		  'Params.alpha * y_A * bcm_fn(y_B)'}});
  buttons.c2 = ...
      uicontrol('Style','PopUp', ...
		'Units','pixels', 'Position',[120 10 100 25], ...
		'String',{'none','y_A','u_bound','-1/y_A','l_bound'}, ...
		'CallBack','label_all_buttons', ...
		'UserData', ...
		{{'','0'}, ...
		 {'\beta y_A','Params.beta * y_A'}, ...
		 {'\beta y_A (\lambda_{max} - w_{AB})',
		  'Params.beta * y_A * (Params.lmax - w_AB)'}, ...
		 {'-\beta y_A^{-1}','-Params.beta * 1/max(0.1,y_A)'}, ...
		 {'-\beta y_A^{-1} (w_{AB} - \lambda_{min})', ...
		  '-Params.beta * 1/max(0.1,y_A) * (w_AB - Params.lmin)'}});

  buttons.c3 = ...
      uicontrol('Style','PopUp', ...
		'Units','pixels', 'Position',[230 10 100 25], ...
		'String',{'none','y_B','u_bound','-1/y_B','l_bound'}, ...
		'CallBack','label_all_buttons', ...
		'UserData', ...
		{{'','0'}, ...
		 {'\gamma y_B','Params.gamma * y_B'}, ...
		 {'\gamma y_B (\lambda_{max} - w_{AB})',
		  'Params.gamma * y_B * (Params.lmax - w_AB)'}, ...
		 {'-\gamma y_B^{-1}','-Params.gamma * 1/max(0.1,y_B)'}, ...
		 {'-\gamma y_B^{-1} (w_{AB} - \lambda_{min})', ...
		  '-Params.gamma * 1/max(0.1,y_B) * (w_AB - Params.lmin)'}});

  buttons.c4 = ...
      uicontrol('Style','PopUp', ...
		'Units','pixels', 'Position',[340 10 100 25], ...
		'String',{'none','bias','w_decay','yB_decay','sq_decay'}, ...
		'CallBack','label_all_buttons', ...
		'UserData',{{'','0'}, ...
			    {'-\delta','-p_delta'}, ...
			    {'-\delta w_{AB}','-p_delta * w_AB'}, ...
			    {'-\delta y_B w_{AB}','-p_delta * y_B * w_AB'}, ...
			    {'-\delta y_B^2','-p_delta * y_B^2'}});

  buttons.patterns = ...
      uicontrol('Style','PopUp', ...
		'Units','pixels', 'Position',[450 10 100 25], ...
		'BackgroundColor',[0.8 0.8 0], ...
		'String','x', ... % String will be set by init_patterns
		'CallBack','do_eval');

  buttons.reset = ...
      uicontrol('Style','PushButton', 'String','Reset', ...
		'Units','pixels', 'Position',[450 80 100 25], ...
		'BackgroundColor',[0.2 0.8 0.2], ...
		'CallBack','init_params; do_eval');

  buttons.textobjs = [];

  global parmpos parmincr
  parmpos = 0.9; parmincr = -0.1;
  buttons.alpha = make_parmbutton('\alpha','alpha');
  buttons.beta  = make_parmbutton('\beta','beta');
  buttons.gamma = make_parmbutton('\gamma','gamma');
  buttons.delta = make_parmbutton('\delta','delta');
  buttons.lmax  = make_parmbutton('\lambda_{max}','lmax');
  buttons.lmin  = make_parmbutton('\lambda_{min}','lmin');
  buttons.w0    = make_parmbutton('w_{AB}(0)','w0');

% ----------------------------------------------------------------

function h = make_parmbutton(tname,pname)

  global axparams Params parmpos parmincr

  h = uicontrol('Style','Edit','String','', ...
		'Units','normalized', 'Position',[0.85 parmpos 0.12 0.05], ...
		'UserData',pname, ...
		'CallBack',['edit_value(gcbo)']);

  subplot(axparams)
  text(0.75,parmpos+0.01,[tname ' ='],'FontSize',12)

  parmpos = parmpos + parmincr;
