% init_graphics.m

global buttons resboxes ibox obox rbox in_bits out_bits weight_objs
global thresh_textobj nbits_textobj
global DELETE_BUTTON_FLAG

clf reset
set(gcf,'Name','Matrix Memory')
bgcol = [0 0 0]; whitebg(gcf,bgcol); set(gcf,'Color',bgcol)
hold on; axis([-20 NUNITS -6 NUNITS]); axis off

DELETE_BUTTON_FLAG = 0;

% Memory and result buttons.
buttons = []; resboxes = []; bx = []; by = [];
for i = 1:NMEM
  bx(i) = 0.05;
  by(i) = 0.95 - i*0.05;
  buttons(i) = ...
      uicontrol('Style','CheckBox', ...
		'HorizontalAlignment','left', 'FontName','Courier', ...
		'CallBack', 'toggle_item', ...
		'Units','normalized','Position',[bx(i) by(i) 0.2 0.05]);
  set(buttons(i),'UserData', ...
      {blanktext,blanktext,blanktext,blankcode,blankcode});
      %  input    output   retrieved   incode   outcode
  set_button_state(buttons(i),0)
  resboxes(i) = ...
      uicontrol('Style','PushButton', ...
		'FontName','Courier', ...
		'Units','normalized', ...
		'Position',[bx(i)+0.25 by(i) 0.06 0.05], ...
		'CallBack','resbutton', ...
		'UserData',buttons(i));  
end

% Input and output text boxes:
ibox = uicontrol('Style','Edit', ...
		 'HorizontalAlignment','left', 'FontName','Courier', ...
		 'Units','normalized', 'Position',[0.05 0.2 0.06 0.05], ...
		 'CallBack','set_ibox; set(obox,''String'','''')');
h=text(0,0,'-->','Color','y', ...
       'FontName','Courier', 'Units','normalized','Position',[-0.01 0.13]);
obox = uicontrol('Style','Edit', ...
		 'HorizontalAlignment','left', 'FontName','Courier', ...
		 'Units','normalized','Position',[0.17 0.2 0.06 0.05], ...
		 'CallBack','validate_text(gcbo);');
rbox = uicontrol('Style','Text', ...
		 'HorizontalAlignment','center', 'FontName','Courier', ...
		 'Units','normalized','Position',[0.3 0.205 0.06 0.04]);


% Control buttons

set_button = ...
    uicontrol('Style','PushButton','String','Set', ...
	      'Units','normalized','Position',[0.05 0.1 0.1 0.05], ...
	      'BackgroundColor',[0.8 0.8 1.0], ...
	      'Callback','set_all_buttons(1)');

reset_button = ...
    uicontrol('Style','PushButton','String','Reset', ...
	      'Units','normalized','Position',[0.05 0.04 0.1 0.05], ...
	      'BackgroundColor',[0.5 0.5 1.0], ...
	      'Callback','set_all_buttons(0);set_ibox('''')');

delete_button = ...
    uicontrol('Style','PushButton','String','Delete', ...
	      'Units','normalized','Position',[0.16 0.1 0.1 0.05], ...
	      'BackgroundColor',[0.2 0.7 0.2], ...
	      'Callback','delete_item');

new_button = ...
    uicontrol('Style','PushButton','String','New', ...
	      'Units','normalized','Position',[0.16 0.04 0.1 0.05], ...
	      'BackgroundColor',[0.4 1.0 0.4], ...
	      'Callback','clear_memory');

random_button = ...
    uicontrol('Style','PushButton','String','Random', ...
	      'Units','normalized','Position',[0.27 0.1 0.1 0.05], ...
	      'BackgroundColor',[1.0 0.4 0.4], ...
	      'Callback','make_random');

density_button = ...
    uicontrol('Style','PushButton','String','Dense', ...
	      'Units','normalized','Position',[0.27 0.04 0.1 0.05], ...
	      'BackgroundColor',[1 0.8 0.3], ...
	      'Callback','dense_sparse');

grid_objs = []; weight_objs = [];
in_bits = []; out_bits = [];
memory_graphics

thresh_textobj = text(2,-5,'Threshold = 0','Color','y');
nbits_textobj =  text(2,-6,'Bits in memory = 0','Color','r');
