# helpers.py
# Lauren Zhang - laurenz@andrew.cmu.edu
# Example:     
#	obj = union_all([beak_faces, head_faces, body_faces])
#	obj.saveSTL("obj.stl")

from .core import CSG
from .geom import Vertex, Vector, Polygon

def convert2csg(faces):
    polys = []
    for face in faces:
        verts = []
        for p in face:
            pos = Vector(p)
            verts += [Vertex(pos)]
        # sometimes the Polygon function doesn't like the verts, 
        # so we just throw them out. CSG.fromPolygons seems to just
        # fix it.
        try:
            poly = Polygon(verts)
            polys += [poly]
        except:
            continue
    obj = CSG.fromPolygons(polys)
    return obj


def union_all(f_arr):
# input array of arrays of faces, i.e. [faces1, faces2, ...], 
# where faces1, faces2, ... are arrays of faces, each representing an object
# output unioned csg object
    duck = convert2csg(f_arr[0])
    for o in f_arr:
        print("converting " + str(len(o)) + " faces")
        duck = duck.union(convert2csg(o))
    return duck
