/* 
 * echoproxy.c - An iterative echo proxy
 */ 
/* $begin echoproxymain */
#include "csapp.h"

void echo_forward(int connfd, char *server, int server_port);

int main(int argc, char **argv) 
{
    int listenfd, connfd, port, clientlen;
    struct sockaddr_in clientaddr;
    struct hostent *hp;
    char *haddrp;

    char *server;
    int   server_port;

    if (argc != 4) {
	fprintf(stderr, "usage: %s <port> <server> <serverport>\n", argv[0]);
	exit(0);
    }
    port = atoi(argv[1]);
    server = argv[2];
    server_port = atoi(argv[3]);
 
    listenfd = Open_listenfd(port);
    while (1) {
	clientlen = sizeof(clientaddr);
	connfd = Accept(listenfd, (SA *)&clientaddr, &clientlen);

	/* determine the domain name and IP address of the client */
	hp = Gethostbyaddr((const char *)&clientaddr.sin_addr.s_addr, 
			   sizeof(clientaddr.sin_addr.s_addr), AF_INET);
	haddrp = inet_ntoa(clientaddr.sin_addr);
	printf("proxy accepts connection from %s (%s)\n", hp->h_name, haddrp);

	echo_forward(connfd, server, server_port);
	Close(connfd);
    }
    exit(0);
}
/* $end echoproxymain */
