/*
 * proxy.c - Web proxy for 15-213 Lab 7
 * 
 *
 */

#include <stdio.h>
#include "csapp.h"
#include "proxy.h"
#include "display.h"

#define   FILTER_FILE   "proxy.filter"
#define   LOG_FILE      "proxy.log"

team_struct team = {
	/* First member full name */
	"Andrew Carnegie",
	/* First member andrew ID */
	"ac01",
	/* Team name */
	""
};

/*============================================================
 * global storage for filters
 *============================================================*/


/*============================================================
 * function declarations
 *============================================================*/

int   find_target_address(char * uri,
			  char * target_address,
			  char * path,
			  int  * port);

void  format_log_entry(char * logstring,
		       int sock,
		       char * uri,
		       int size);

/* main function for the proxy program */
int main(int argc, char *argv[])
{
    int   port;
    if (argc != 2) {
	printf("Usage: ./%s port\n", argv[0]);
	exit(1);
    }
    
    /* initializes the xlib graphics display 
       showing the number of connections    */
    init_display_window (argc, argv);
    
    
    /*****************************************
     * fill in proxy code here ;o)           *
     ******************************************/

    port = 0;    

/* demo code to illustrate how to change the graphic display. */
/* replace this code                                          */
/* with your own code                                         */

    while (1) {
         
       sleep(1);

       change_display (port++);
       
       if (port > 20)
           break;
    }

/* end of demo code                                             */
    
    /* destroys xlib display */
    destroy_window (); 
    
    return 0;
}

/*============================================================
 * url parser:
 *    find_target_address()
 *        Given a url, copy the target web server address to
 *        target_address and the following path to path.
 *        Also copies the port number into port
 *
 *        target_address and path must be allocated before 
 *        calling this function. use MAXLINE as a safe length
 *
 *        Returns -1 if there is
 *        any error in parsing the url. 0 otherwise
 *
 *============================================================*/

/*find_target_address - find the host name from the uri */
int  find_target_address(char * uri, char * target_address, char * path,
                         int * port)
{
    if (strncasecmp(uri, "http://", 7) == 0) {
	char * hostbegin, * hostend, *pathbegin;
	int    len;

        /* set port to the default http port */
        *port = 80;

	/* find the target address */
	hostbegin = uri+7;
	hostend = strpbrk(hostbegin, " :/\r\n\0");
	len = hostend - hostbegin;
	strncpy(target_address, hostbegin, len);
	target_address[len] = '\0';

	/* find the port number */
	if (*hostend == ':')  *port = atoi(hostend+1);

	/* find the path */
	pathbegin = strchr(hostbegin, '/');

	if (pathbegin == NULL) {
	    path[0] = '\0';
	}
	else {
   	    pathbegin++;                 // we don't want the / in the path	
	    strcpy(path, pathbegin);
	}
	
	return 0;
    }
    target_address[0] = '\0';
    return -1;
}

/*============================================================
 * log utility
 *    format_log_entry
 *       Copy the formatted log entry to logstring
 *============================================================*/

void format_log_entry(char * logstring, int sock, char * uri, int size)
{
    time_t  now;
    char    buffer[MAXLINE];
    struct  sockaddr_in addr;
    unsigned  long  host;
    unsigned  char a, b, c, d;
    int    len = sizeof(addr);

    now = time(NULL);
    strftime(buffer, MAXLINE, "%a %d %b %Y %H:%M:%S %Z", localtime(&now));

    if (getpeername(sock, (struct sockaddr *) & addr, &len)) {
	unix_error("Can't get peer name");
    }

    host = ntohl(addr.sin_addr.s_addr);
    a = host >> 24;
    b = (host >> 16) & 0xff;
    c = (host >> 8) & 0xff;
    d = host & 0xff;

    sprintf(logstring, "%s: %d.%d.%d.%d %s %d", buffer, a,b,c,d, uri, size);
}
