#include "sparray.hpp"
#include <malloc.h>

#ifndef _DEMO_TABULATE_H_
#define _DEMO_TABULATE_H_

namespace demo {
/*
void tabulate_seq(long* data, long lo, long hi) {
  for (long i = lo; i < hi; i++) data[i] = i;
}

const long threshold = 10;

controller_type tab_contr("unique string please");

void tab_rec(long* data, long lo, long hi) {
  long n = hi - lo;
  par::cstmt(tab_contr, [&] { return n; }, [&] {
    if (n <= threshold) { tabulate_seq(data, lo, hi); return; }
    long mid = lo + n / 2;
    par::fork2([&] { tab_rec(data, lo, mid); },
               [&] { tab_rec(data, mid, hi); });
  }, [&] {
    tabulate_seq(data, lo, hi);
  });
}

void tabulate(long* data, long n) {
  tab_rec(data, 0, n); 
}
*/

loop_controller_type tabulate_contr("tabulate_contr");

void tabulate(long* data, long n) {
  auto complexity_func =
    [&] (long lo, long hi) { return hi - lo; };
  par::parallel_for(tabulate_contr, complexity_func, 0L, n, [&] (long i) {
    data[i] = i;
  });
}

}

#endif
