#include "sparray.hpp"

#ifndef _DEMO_FILTER_H_
#define _DEMO_FILTER_H_

namespace demo {

template <class Pred>
sparray filter_seq(const Pred& p, sparray& xs) {
  long n = xs.size(); // size of the array xs
  bool* ps = (bool*) malloc(n * sizeof(bool));
  long m = 0;
  for (long i = 0; i < n; i++) {
    if (p(xs[i])) {
      ps[i] = true;
      m++;
    }
  }

  sparray result(m); // allocate array of length m
  long j = 0;
  for (long i = 0; i < n; i++) if (ps[i]) { result[j] = ps[i]; j++; }
  free(ps);
  return result;
}

loop_controller_type filter_contr("filter_contr in class");

template <class Pred>
sparray filter(const Pred& p, const sparray& xs) {
  long n = xs.size();
  
  scan_excl_result offsets = scan_excl(
    [] (long a, long b) { return a + b; },
    p,
    0,
    xs);
  // offsets.partials : sparray
  // offsets.total : long
  long m = offsets.total;

  sparray result(m);
  par::parallel_for(filter_contr, (long)0, n, [&] (long i) {
    auto x = xs[i];
    long curr = offsets.partials[i];
    long next = i == n-1 ? m : offsets.partials[i+1];
    if (curr != next) {
      result[curr] = x;
    }
  });
  return result;
}

} /* namespace demo */

#endif /* _DEMO_FILTER_H_ */
